/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.schema.bootstrap;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.ldap.server.schema.ComparatorRegistry;
import org.apache.ldap.server.schema.ComparatorRegistryMonitor;
import org.apache.ldap.server.schema.ComparatorRegistryMonitorAdapter;
import org.apache.ldap.server.schema.SerializableComparator;

public class BootstrapComparatorRegistry
implements ComparatorRegistry {
    private final Map comparators;
    private final Map oidToSchema = new HashMap();
    private ComparatorRegistryMonitor monitor;

    public BootstrapComparatorRegistry() {
        this.comparators = new HashMap();
        this.monitor = new ComparatorRegistryMonitorAdapter();
        SerializableComparator.setRegistry(this);
    }

    public void setMonitor(ComparatorRegistryMonitor monitor) {
        this.monitor = monitor;
    }

    public void register(String schema, String oid, Comparator comparator) throws NamingException {
        if (this.comparators.containsKey(oid)) {
            NamingException e = new NamingException("Comparator with OID " + oid + " already registered!");
            this.monitor.registerFailed(oid, comparator, e);
            throw e;
        }
        this.oidToSchema.put(oid, schema);
        this.comparators.put(oid, comparator);
        this.monitor.registered(oid, comparator);
    }

    public Comparator lookup(String oid) throws NamingException {
        if (this.comparators.containsKey(oid)) {
            Comparator c = (Comparator)this.comparators.get(oid);
            this.monitor.lookedUp(oid, c);
            return c;
        }
        NamingException e = new NamingException("Comparator not found for OID: " + oid);
        this.monitor.lookupFailed(oid, e);
        throw e;
    }

    public boolean hasComparator(String oid) {
        return this.comparators.containsKey(oid);
    }

    public String getSchemaName(String oid) throws NamingException {
        if (!Character.isDigit(oid.charAt(0))) {
            throw new NamingException("OID " + oid + " is not a numeric OID");
        }
        if (this.oidToSchema.containsKey(oid)) {
            return (String)this.oidToSchema.get(oid);
        }
        throw new NamingException("OID " + oid + " not found in oid to " + "schema name map!");
    }
}

