/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.schema;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.ldap.common.Lockable;
import org.apache.ldap.common.filter.ExprNode;
import org.apache.ldap.common.filter.PresenceNode;
import org.apache.ldap.common.filter.SimpleNode;
import org.apache.ldap.common.message.LockableAttributeImpl;
import org.apache.ldap.common.message.LockableAttributesImpl;
import org.apache.ldap.common.name.LdapName;
import org.apache.ldap.common.schema.AttributeType;
import org.apache.ldap.common.schema.DITContentRule;
import org.apache.ldap.common.schema.DITStructureRule;
import org.apache.ldap.common.schema.MatchingRule;
import org.apache.ldap.common.schema.MatchingRuleUse;
import org.apache.ldap.common.schema.NameForm;
import org.apache.ldap.common.schema.ObjectClass;
import org.apache.ldap.common.schema.SchemaUtils;
import org.apache.ldap.common.schema.Syntax;
import org.apache.ldap.common.util.SingletonEnumeration;
import org.apache.ldap.server.RootNexus;
import org.apache.ldap.server.db.ResultFilteringEnumeration;
import org.apache.ldap.server.db.SearchResultFilter;
import org.apache.ldap.server.interceptor.BaseInterceptor;
import org.apache.ldap.server.interceptor.InterceptorContext;
import org.apache.ldap.server.interceptor.NextInterceptor;
import org.apache.ldap.server.invocation.List;
import org.apache.ldap.server.invocation.Lookup;
import org.apache.ldap.server.invocation.LookupWithAttrIds;
import org.apache.ldap.server.invocation.Search;
import org.apache.ldap.server.jndi.ServerLdapContext;
import org.apache.ldap.server.schema.AttributeTypeRegistry;
import org.apache.ldap.server.schema.GlobalRegistries;

public class SchemaService
extends BaseInterceptor {
    private static final String BINARY_KEY = "java.naming.ldap.attributes.binary";
    private RootNexus nexus;
    private BinaryAttributeFilter binaryAttributeFilter;
    private GlobalRegistries globalRegistries;
    private AttributeTypeRegistry attributeRegistry;
    private String subentryDn;

    public void init(InterceptorContext ctx) throws NamingException {
        this.nexus = ctx.getRootNexus();
        this.globalRegistries = ctx.getGlobalRegistries();
        this.attributeRegistry = this.globalRegistries.getAttributeTypeRegistry();
        this.binaryAttributeFilter = new BinaryAttributeFilter();
        String subschemaSubentry = (String)this.nexus.getRootDSE().get("subschemaSubentry").get();
        this.subentryDn = new LdapName(subschemaSubentry).toString().toLowerCase();
    }

    public void destroy() {
    }

    protected void process(NextInterceptor nextInterceptor, List call) throws NamingException {
        nextInterceptor.process(call);
        LdapContext ctx = (LdapContext)call.getContextStack().peek();
        NamingEnumeration e = (NamingEnumeration)call.getReturnValue();
        ResultFilteringEnumeration retval = new ResultFilteringEnumeration(e, new SearchControls(), ctx, this.binaryAttributeFilter);
        call.setReturnValue(retval);
    }

    protected void process(NextInterceptor nextInterceptor, Search call) throws NamingException {
        SearchResult result;
        Attributes attrs;
        SimpleNode node;
        if (!this.subentryDn.equals(call.getBaseName().toString())) {
            nextInterceptor.process(call);
            return;
        }
        boolean bypass = false;
        SearchControls searchControls = call.getControls();
        ExprNode filter = call.getFilter();
        if (searchControls.getSearchScope() == 0 && filter instanceof SimpleNode) {
            node = (SimpleNode)filter;
            if (node.getAttribute().equalsIgnoreCase("objectClass") && node.getValue().equalsIgnoreCase("subschema") && node.getAssertionType() == 0) {
                attrs = this.getSubschemaEntry(searchControls.getReturningAttributes());
                result = new SearchResult(call.getBaseName().toString(), (Object)null, attrs);
                SingletonEnumeration e = new SingletonEnumeration((Object)result);
                call.setReturnValue(e);
                bypass = true;
            }
        } else if (searchControls.getSearchScope() == 0 && filter instanceof PresenceNode && (node = (PresenceNode)filter).getAttribute().equalsIgnoreCase("objectClass")) {
            attrs = this.getSubschemaEntry(searchControls.getReturningAttributes());
            result = new SearchResult(call.getBaseName().toString(), (Object)null, attrs);
            SingletonEnumeration e = new SingletonEnumeration((Object)result);
            call.setReturnValue(e);
            bypass = true;
        }
        if (!bypass) {
            nextInterceptor.process(call);
        }
        if (searchControls.getReturningAttributes() != null) {
            return;
        }
        LdapContext ctx = (LdapContext)call.getContextStack().peek();
        NamingEnumeration e = (NamingEnumeration)call.getReturnValue();
        ResultFilteringEnumeration retval = new ResultFilteringEnumeration(e, searchControls, ctx, this.binaryAttributeFilter);
        call.setReturnValue(retval);
    }

    private Attributes getSubschemaEntry(String[] ids) throws NamingException {
        if (ids == null) {
            return new LockableAttributesImpl();
        }
        HashSet<String> set = new HashSet<String>(ids.length);
        LockableAttributesImpl attrs = new LockableAttributesImpl();
        LockableAttributeImpl attr = null;
        int ii = 0;
        while (ii < ids.length) {
            set.add(ids[ii].toLowerCase());
            ++ii;
        }
        if (set.contains("objectclasses")) {
            attr = new LockableAttributeImpl((Lockable)attrs, "objectClasses");
            Iterator list = this.globalRegistries.getObjectClassRegistry().list();
            while (list.hasNext()) {
                ObjectClass oc = (ObjectClass)list.next();
                attr.add((Object)SchemaUtils.render((ObjectClass)oc).toString());
            }
            attrs.put((Attribute)attr);
        }
        if (set.contains("attributetypes")) {
            attr = new LockableAttributeImpl((Lockable)attrs, "attributeTypes");
            Iterator list = this.globalRegistries.getAttributeTypeRegistry().list();
            while (list.hasNext()) {
                AttributeType at = (AttributeType)list.next();
                attr.add((Object)SchemaUtils.render((AttributeType)at).toString());
            }
            attrs.put((Attribute)attr);
        }
        if (set.contains("matchingrules")) {
            attr = new LockableAttributeImpl((Lockable)attrs, "matchingRules");
            Iterator list = this.globalRegistries.getMatchingRuleRegistry().list();
            while (list.hasNext()) {
                MatchingRule mr = (MatchingRule)list.next();
                attr.add((Object)SchemaUtils.render((MatchingRule)mr).toString());
            }
            attrs.put((Attribute)attr);
        }
        if (set.contains("matchingruleuse")) {
            attr = new LockableAttributeImpl((Lockable)attrs, "matchingRuleUse");
            Iterator list = this.globalRegistries.getMatchingRuleUseRegistry().list();
            while (list.hasNext()) {
                MatchingRuleUse mru = (MatchingRuleUse)list.next();
                attr.add((Object)SchemaUtils.render((MatchingRuleUse)mru).toString());
            }
            attrs.put((Attribute)attr);
        }
        if (set.contains("ldapsyntaxes")) {
            attr = new LockableAttributeImpl((Lockable)attrs, "ldapSyntaxes");
            Iterator list = this.globalRegistries.getSyntaxRegistry().list();
            while (list.hasNext()) {
                Syntax syntax = (Syntax)list.next();
                attr.add((Object)SchemaUtils.render((Syntax)syntax).toString());
            }
            attrs.put((Attribute)attr);
        }
        if (set.contains("ditcontentrules")) {
            attr = new LockableAttributeImpl((Lockable)attrs, "dITContentRules");
            Iterator list = this.globalRegistries.getDitContentRuleRegistry().list();
            while (list.hasNext()) {
                DITContentRule dcr = (DITContentRule)list.next();
                attr.add((Object)SchemaUtils.render((DITContentRule)dcr).toString());
            }
            attrs.put((Attribute)attr);
        }
        if (set.contains("ditstructurerules")) {
            attr = new LockableAttributeImpl((Lockable)attrs, "dITStructureRules");
            Iterator list = this.globalRegistries.getDitStructureRuleRegistry().list();
            while (list.hasNext()) {
                DITStructureRule dsr = (DITStructureRule)list.next();
                attr.add((Object)SchemaUtils.render((DITStructureRule)dsr).toString());
            }
            attrs.put((Attribute)attr);
        }
        if (set.contains("nameforms")) {
            attr = new LockableAttributeImpl((Lockable)attrs, "nameForms");
            Iterator list = this.globalRegistries.getNameFormRegistry().list();
            while (list.hasNext()) {
                NameForm nf = (NameForm)list.next();
                attr.add((Object)SchemaUtils.render((NameForm)nf).toString());
            }
            attrs.put((Attribute)attr);
        }
        attr = new LockableAttributeImpl((Lockable)attrs, "objectClass");
        attr.add((Object)"top");
        attr.add((Object)"subschema");
        attrs.put((Attribute)attr);
        attrs.put("cn", (Object)"schema");
        return attrs;
    }

    protected void process(NextInterceptor nextInterceptor, Lookup call) throws NamingException {
        nextInterceptor.process(call);
        ServerLdapContext ctx = (ServerLdapContext)call.getContextStack().peek();
        Attributes attributes = (Attributes)call.getReturnValue();
        Attributes retval = (Attributes)attributes.clone();
        this.doFilter(ctx, retval);
        call.setReturnValue(retval);
    }

    protected void process(NextInterceptor nextInterceptor, LookupWithAttrIds call) throws NamingException {
        nextInterceptor.process(call);
        ServerLdapContext ctx = (ServerLdapContext)call.getContextStack().peek();
        Attributes attributes = (Attributes)call.getReturnValue();
        if (attributes == null) {
            return;
        }
        Attributes retval = (Attributes)attributes.clone();
        this.doFilter(ctx, retval);
        call.setReturnValue(retval);
    }

    private void doFilter(LdapContext ctx, Attributes entry) throws NamingException {
        AttributeType type;
        HashSet<AttributeType> binaries;
        String binaryIds = (String)ctx.getEnvironment().get(BINARY_KEY);
        if (binaryIds == null) {
            binaries = Collections.EMPTY_SET;
        } else {
            String[] binaryArray = binaryIds.split(" ");
            binaries = new HashSet<AttributeType>(binaryArray.length);
            int ii = 0;
            while (ii < binaryArray.length) {
                type = this.attributeRegistry.lookup(binaryArray[ii]);
                binaries.add(type);
                ++ii;
            }
        }
        NamingEnumeration<String> list = entry.getIDs();
        while (list.hasMore()) {
            String id = list.next();
            type = null;
            boolean asBinary = false;
            if (this.attributeRegistry.hasAttributeType(id)) {
                type = this.attributeRegistry.lookup(id);
            }
            if (type != null) {
                asBinary = !type.getSyntax().isHumanReadible();
                boolean bl = asBinary = asBinary || binaries.contains(type);
            }
            if (!asBinary) continue;
            Attribute attribute = entry.get(id);
            LockableAttributeImpl binary = new LockableAttributeImpl(id);
            int ii = 0;
            while (ii < attribute.size()) {
                Object value = attribute.get(ii);
                if (value instanceof String) {
                    binary.add(ii, ((String)value).getBytes());
                } else {
                    binary.add(ii, value);
                }
                ++ii;
            }
            entry.remove(id);
            entry.put((Attribute)binary);
        }
    }

    private class BinaryAttributeFilter
    implements SearchResultFilter {
        public boolean accept(LdapContext ctx, SearchResult result, SearchControls controls) throws NamingException {
            SchemaService.this.doFilter(ctx, result.getAttributes());
            return true;
        }
    }
}

