/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.schema;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.ldap.common.schema.NameForm;
import org.apache.ldap.common.util.JoinIterator;
import org.apache.ldap.server.SystemPartition;
import org.apache.ldap.server.schema.NameFormRegistry;
import org.apache.ldap.server.schema.NameFormRegistryMonitor;
import org.apache.ldap.server.schema.NameFormRegistryMonitorAdapter;
import org.apache.ldap.server.schema.OidRegistry;
import org.apache.ldap.server.schema.bootstrap.BootstrapNameFormRegistry;

public class GlobalNameFormRegistry
implements NameFormRegistry {
    private final Map byOid = new HashMap();
    private final Map oidToSchema = new HashMap();
    private final OidRegistry oidRegistry;
    private NameFormRegistryMonitor monitor;
    private BootstrapNameFormRegistry bootstrap;
    private SystemPartition systemPartition;

    public GlobalNameFormRegistry(SystemPartition systemPartition, BootstrapNameFormRegistry bootstrap, OidRegistry oidRegistry) {
        this.oidRegistry = oidRegistry;
        this.monitor = new NameFormRegistryMonitorAdapter();
        this.bootstrap = bootstrap;
        if (this.bootstrap == null) {
            throw new NullPointerException("the bootstrap registry cannot be null");
        }
        this.systemPartition = systemPartition;
        if (this.systemPartition == null) {
            throw new NullPointerException("the system partition cannot be null");
        }
    }

    public void setMonitor(NameFormRegistryMonitor monitor) {
        this.monitor = monitor;
    }

    public void register(String schema, NameForm dITContentRule) throws NamingException {
        if (this.byOid.containsKey(dITContentRule.getOid()) || this.bootstrap.hasNameForm(dITContentRule.getOid())) {
            NamingException e = new NamingException("dITContentRule w/ OID " + dITContentRule.getOid() + " has already been registered!");
            this.monitor.registerFailed(dITContentRule, e);
            throw e;
        }
        this.oidRegistry.register(dITContentRule.getName(), dITContentRule.getOid());
        this.byOid.put(dITContentRule.getOid(), dITContentRule);
        this.oidToSchema.put(dITContentRule.getOid(), schema);
        this.monitor.registered(dITContentRule);
    }

    public NameForm lookup(String id) throws NamingException {
        if (this.byOid.containsKey(id = this.oidRegistry.getOid(id))) {
            NameForm dITContentRule = (NameForm)this.byOid.get(id);
            this.monitor.lookedUp(dITContentRule);
            return dITContentRule;
        }
        if (this.bootstrap.hasNameForm(id)) {
            NameForm dITContentRule = this.bootstrap.lookup(id);
            this.monitor.lookedUp(dITContentRule);
            return dITContentRule;
        }
        NamingException e = new NamingException("dITContentRule w/ OID " + id + " not registered!");
        this.monitor.lookupFailed(id, e);
        throw e;
    }

    public boolean hasNameForm(String id) {
        if (this.oidRegistry.hasOid(id)) {
            try {
                return this.byOid.containsKey(this.oidRegistry.getOid(id)) || this.bootstrap.hasNameForm(id);
            }
            catch (NamingException namingException) {
                return false;
            }
        }
        return false;
    }

    public String getSchemaName(String id) throws NamingException {
        if (this.oidToSchema.containsKey(id = this.oidRegistry.getOid(id))) {
            return (String)this.oidToSchema.get(id);
        }
        if (this.bootstrap.hasNameForm(id)) {
            return this.bootstrap.getSchemaName(id);
        }
        throw new NamingException("OID " + id + " not found in oid to " + "schema name map!");
    }

    public Iterator list() {
        return new JoinIterator(new Iterator[]{this.byOid.values().iterator(), this.bootstrap.list()});
    }
}

