/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.jndi;

import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Hashtable;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.Control;
import javax.naming.spi.DirStateFactory;
import javax.naming.spi.DirectoryManager;
import org.apache.ldap.common.filter.BranchNode;
import org.apache.ldap.common.filter.ExprNode;
import org.apache.ldap.common.filter.FilterParserImpl;
import org.apache.ldap.common.filter.PresenceNode;
import org.apache.ldap.common.filter.SimpleNode;
import org.apache.ldap.common.name.LdapName;
import org.apache.ldap.common.util.NamespaceTools;
import org.apache.ldap.server.ContextPartition;
import org.apache.ldap.server.PartitionNexus;
import org.apache.ldap.server.authn.LdapPrincipal;
import org.apache.ldap.server.db.Database;
import org.apache.ldap.server.jndi.JavaLdapSupport;
import org.apache.ldap.server.jndi.ProviderNexusAspect;
import org.apache.ldap.server.jndi.ServerContext;
import org.apache.ldap.server.jndi.ServerLdapContext;

public abstract class ServerDirContext
extends ServerContext
implements DirContext {
    public ServerDirContext(PartitionNexus nexusProxy, Hashtable env) throws NamingException {
        super(nexusProxy, env);
    }

    protected ServerDirContext(LdapPrincipal principal, PartitionNexus nexusProxy, Hashtable env, Name dn) {
        super(principal, nexusProxy, env, dn);
    }

    public Attributes getAttributes(String name) throws NamingException {
        return this.getAttributes((Name)new LdapName(name));
    }

    public Attributes getAttributes(Name name) throws NamingException {
        Attributes attributes;
        LdapName ldapName = this.buildTarget(name);
        PartitionNexus partitionNexus = this.getNexusProxy();
        try {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
            }
            attributes = partitionNexus.lookup((Name)ldapName);
        }
        finally {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
            }
        }
        return attributes;
    }

    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        return this.getAttributes((Name)new LdapName(name), attrIds);
    }

    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        Attributes attributes;
        String[] stringArray = attrIds;
        LdapName ldapName = this.buildTarget(name);
        PartitionNexus partitionNexus = this.getNexusProxy();
        try {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
            }
            attributes = partitionNexus.lookup((Name)ldapName, stringArray);
        }
        finally {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
            }
        }
        return attributes;
    }

    public void modifyAttributes(String name, int modOp, Attributes attrs) throws NamingException {
        this.modifyAttributes((Name)new LdapName(name), modOp, attrs);
    }

    public void modifyAttributes(Name name, int modOp, Attributes attrs) throws NamingException {
        Attributes attributes = attrs;
        int n = modOp;
        LdapName ldapName = this.buildTarget(name);
        PartitionNexus partitionNexus = this.getNexusProxy();
        try {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
            }
            partitionNexus.modify((Name)ldapName, n, attributes);
        }
        finally {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
            }
        }
    }

    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        this.modifyAttributes((Name)new LdapName(name), mods);
    }

    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        ModificationItem[] modificationItemArray = mods;
        LdapName ldapName = this.buildTarget(name);
        PartitionNexus partitionNexus = this.getNexusProxy();
        try {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
            }
            partitionNexus.modify((Name)ldapName, modificationItemArray);
        }
        finally {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
            }
        }
    }

    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        this.bind((Name)new LdapName(name), obj, attrs);
    }

    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        if (obj == null && attrs == null) {
            throw new NamingException("Both obj and attrs args are null. At least one of these parameters must not be null.");
        }
        if (attrs == null) {
            super.bind(name, obj);
            return;
        }
        if (obj == null) {
            Attributes clone = (Attributes)attrs.clone();
            LdapName target = this.buildTarget(name);
            Attributes attributes = clone;
            LdapName ldapName = target;
            String string = target.toString();
            PartitionNexus partitionNexus = this.getNexusProxy();
            try {
                if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
                }
                partitionNexus.add(string, (Name)ldapName, attributes);
            }
            finally {
                if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
                }
            }
            return;
        }
        DirStateFactory.Result res = DirectoryManager.getStateToBind(obj, name, this, this.getEnvironment(), attrs);
        Attributes outAttrs = res.getAttributes();
        if (outAttrs != attrs) {
            LdapName target = this.buildTarget(name);
            Attributes attributes = (Attributes)attrs.clone();
            if (outAttrs != null && outAttrs.size() > 0) {
                NamingEnumeration<? extends Attribute> list = outAttrs.getAll();
                while (list.hasMore()) {
                    attributes.put(list.next());
                }
            }
            Attributes attributes2 = attributes;
            LdapName ldapName = target;
            String string = target.toString();
            PartitionNexus partitionNexus = this.getNexusProxy();
            try {
                if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
                }
                partitionNexus.add(string, (Name)ldapName, attributes2);
            }
            finally {
                if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
                }
            }
            return;
        }
        if (obj instanceof Referenceable) {
            obj = ((Referenceable)obj).getReference();
            throw new NamingException("Do not know how to store Referenceables yet!");
        }
        if (obj instanceof Reference) {
            throw new NamingException("Do not know how to store References yet!");
        }
        if (obj instanceof Serializable) {
            Attributes attributes = (Attributes)attrs.clone();
            if (outAttrs != null && outAttrs.size() > 0) {
                NamingEnumeration<? extends Attribute> list = outAttrs.getAll();
                while (list.hasMore()) {
                    attributes.put(list.next());
                }
            }
            LdapName target = this.buildTarget(name);
            JavaLdapSupport.serialize(attributes, obj);
            Attributes attributes3 = attributes;
            LdapName ldapName = target;
            String string = target.toString();
            PartitionNexus partitionNexus = this.getNexusProxy();
            try {
                if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
                }
                partitionNexus.add(string, (Name)ldapName, attributes3);
            }
            finally {
                if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
                }
            }
        } else if (obj instanceof DirContext) {
            Object target;
            Attributes attributes = ((DirContext)obj).getAttributes("");
            if (outAttrs != null && outAttrs.size() > 0) {
                target = outAttrs.getAll();
                while (target.hasMore()) {
                    attributes.put((Attribute)target.next());
                }
            }
            target = this.buildTarget(name);
            Attributes attributes4 = attributes;
            Object object = target;
            String string = target.toString();
            PartitionNexus partitionNexus = this.getNexusProxy();
            try {
                if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
                }
                partitionNexus.add(string, (Name)object, attributes4);
            }
            finally {
                if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
                }
            }
        } else {
            throw new NamingException("Can't find a way to bind: " + obj);
        }
    }

    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        this.rebind((Name)new LdapName(name), obj, attrs);
    }

    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        boolean bl;
        LdapName target;
        LdapName ldapName = target = this.buildTarget(name);
        PartitionNexus partitionNexus = this.getNexusProxy();
        try {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
            }
            bl = partitionNexus.hasEntry((Name)ldapName);
        }
        finally {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
            }
        }
        if (bl) {
            LdapName ldapName2 = target;
            PartitionNexus partitionNexus2 = this.getNexusProxy();
            try {
                if (!(this instanceof ContextPartition) && !(partitionNexus2 instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
                }
                partitionNexus2.delete((Name)ldapName2);
            }
            finally {
                if (!(this instanceof ContextPartition) && !(partitionNexus2 instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
                }
            }
        }
        this.bind(name, obj, attrs);
    }

    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        return this.createSubcontext((Name)new LdapName(name), attrs);
    }

    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        if (attrs == null) {
            return (DirContext)super.createSubcontext(name);
        }
        LdapName target = this.buildTarget(name);
        String rdn = name.get(name.size() - 1);
        String rdnAttribute = NamespaceTools.getRdnAttribute((String)rdn);
        String rdnValue = NamespaceTools.getRdnValue((String)rdn);
        Attributes attributes = (Attributes)attrs.clone();
        boolean doRdnPut = attributes.get(rdnAttribute) == null;
        doRdnPut = doRdnPut || attributes.get(rdnAttribute).size() == 0;
        boolean bl = doRdnPut = doRdnPut || !attributes.get(rdnAttribute).contains(rdnValue);
        if (doRdnPut) {
            attributes.put(rdnAttribute, rdnValue);
        }
        Attributes attributes2 = attributes;
        LdapName ldapName = target;
        String string = target.toString();
        PartitionNexus partitionNexus = this.getNexusProxy();
        try {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
            }
            partitionNexus.add(string, (Name)ldapName, attributes2);
        }
        finally {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
            }
        }
        ServerLdapContext ctx = new ServerLdapContext(this.getPrincipal(), this.getNexusProxy(), this.getEnvironment(), (Name)target);
        Control[] controls = ((ServerLdapContext)this).getRequestControls();
        controls = controls != null ? (Control[])controls.clone() : new Control[]{};
        ctx.setRequestControls(controls);
        return ctx;
    }

    public DirContext getSchema(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public DirContext getSchema(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes) throws NamingException {
        return this.search((Name)new LdapName(name), matchingAttributes, null);
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes) throws NamingException {
        return this.search(name, matchingAttributes, null);
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.search((Name)new LdapName(name), matchingAttributes, attributesToReturn);
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        NamingEnumeration namingEnumeration;
        SearchControls ctls = new SearchControls();
        LdapName target = this.buildTarget(name);
        if (attributesToReturn != null) {
            ctls.setReturningAttributes(attributesToReturn);
        }
        if (matchingAttributes == null || matchingAttributes.size() <= 0) {
            NamingEnumeration namingEnumeration2;
            PresenceNode filter = new PresenceNode("objectClass");
            SearchControls searchControls = ctls;
            PresenceNode presenceNode = filter;
            Hashtable hashtable = this.getEnvironment();
            LdapName ldapName = target;
            PartitionNexus partitionNexus = this.getNexusProxy();
            try {
                if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
                }
                namingEnumeration2 = partitionNexus.search((Name)ldapName, hashtable, (ExprNode)presenceNode, searchControls);
            }
            finally {
                if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
                }
            }
            return namingEnumeration2;
        }
        Attribute attr = null;
        SimpleNode node = null;
        BranchNode filter = new BranchNode(10);
        NamingEnumeration<? extends Attribute> list = matchingAttributes.getAll();
        while (list.hasMore()) {
            attr = list.next();
            if (attr.size() == 0) {
                filter.addNode((ExprNode)new PresenceNode(attr.getID()));
                continue;
            }
            int ii = 0;
            while (ii < attr.size()) {
                Object val = attr.get(ii);
                if (val instanceof String) {
                    node = new SimpleNode(attr.getID(), (String)val, 0);
                    filter.addNode((ExprNode)node);
                }
                ++ii;
            }
        }
        SearchControls searchControls = ctls;
        BranchNode branchNode = filter;
        Hashtable hashtable = this.getEnvironment();
        LdapName ldapName = target;
        PartitionNexus partitionNexus = this.getNexusProxy();
        try {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
            }
            namingEnumeration = partitionNexus.search((Name)ldapName, hashtable, (ExprNode)branchNode, searchControls);
        }
        finally {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
            }
        }
        return namingEnumeration;
    }

    public NamingEnumeration search(String name, String filter, SearchControls cons) throws NamingException {
        return this.search((Name)new LdapName(name), filter, cons);
    }

    public NamingEnumeration search(Name name, String filter, SearchControls cons) throws NamingException {
        NamingEnumeration namingEnumeration;
        ExprNode filterNode = null;
        LdapName target = this.buildTarget(name);
        if (filter == null && this.getEnvironment().containsKey("__filter__")) {
            filterNode = (ExprNode)this.getEnvironment().get("__filter__");
        } else {
            try {
                FilterParserImpl parser = new FilterParserImpl();
                filterNode = parser.parse(filter);
            }
            catch (ParseException pe) {
                InvalidSearchFilterException isfe = new InvalidSearchFilterException("Encountered parse exception while parsing the filter: '" + filter + "'");
                isfe.setRootCause(pe);
                throw isfe;
            }
            catch (IOException ioe) {
                NamingException ne = new NamingException("Parser failed with IO exception on filter: '" + filter + "'");
                ne.setRootCause(ioe);
                throw ne;
            }
        }
        SearchControls searchControls = cons;
        ExprNode exprNode = filterNode;
        Hashtable hashtable = this.getEnvironment();
        LdapName ldapName = target;
        PartitionNexus partitionNexus = this.getNexusProxy();
        try {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095(this);
            }
            namingEnumeration = partitionNexus.search((Name)ldapName, hashtable, exprNode, searchControls);
        }
        finally {
            if (!(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095(this);
            }
        }
        return namingEnumeration;
    }

    public NamingEnumeration search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.search((Name)new LdapName(name), filterExpr, filterArgs, cons);
    }

    /*
     * Unable to fully structure code
     */
    public NamingEnumeration search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        buf = new StringBuffer(filterExpr);
        ii = 0;
        ** GOTO lbl14
        {
            ++ii;
            do {
                if ('{' != buf.charAt(ii)) continue block0;
                start = ii;
                while ('}' != buf.charAt(ii)) {
                    ++ii;
                }
                buf.replace(start, ii + 1, filterArgs[ii].toString());
                ++ii;
lbl14:
                // 2 sources

            } while (ii < buf.length());
        }
        return this.search(name, buf.toString(), cons);
    }
}

