/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.jndi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;

public class JavaLdapSupport {
    public static final String TOP_ATTR = "top";
    public static final String JOBJECT_ATTR = "javaObject";
    public static final String OBJECTCLASS_ATTR = "objectClass";
    public static final String JCONTAINER_ATTR = "javaContainer";
    public static final String JSERIALIZEDOBJ_ATTR = "javaSerializedObject";
    public static final String JCLASSNAME_ATTR = "javaClassName";
    public static final String JCLASSNAMES_ATTR = "javaClassNames";
    public static final String JSERIALDATA_ATTR = "javaSerializedData";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Object deserialize(Attributes attributes) throws NamingException {
        Object object;
        ObjectInputStream in = null;
        String className = (String)attributes.get(JCLASSNAME_ATTR).get();
        try {
            try {
                byte[] data = (byte[])attributes.get(JSERIALDATA_ATTR).get();
                in = new ObjectInputStream(new ByteArrayInputStream(data));
                object = in.readObject();
                Object var5_6 = null;
            }
            catch (Exception e) {
                NamingException ne = new NamingException("De-serialization of '" + className + "' instance failed:\n" + e.getMessage());
                ne.setRootCause(e);
                throw ne;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new NamingException("object deserialization stream close() failure");
            }
        }
        try {}
        catch (IOException iOException) {
            throw new NamingException("object deserialization stream close() failure");
        }
        in.close();
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] serialize(Object obj) throws NamingException {
        byte[] byArray;
        ByteArrayOutputStream bytesOut = null;
        ObjectOutputStream out = null;
        try {
            try {
                bytesOut = new ByteArrayOutputStream();
                out = new ObjectOutputStream(bytesOut);
                out.writeObject(obj);
                byArray = bytesOut.toByteArray();
                Object var5_4 = null;
            }
            catch (Exception e) {
                NamingException ne = new NamingException("Serialization of '" + obj + "' failed:\n" + e.getMessage());
                ne.setRootCause(e);
                throw ne;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new NamingException("object serialization stream close() failure");
            }
        }
        try {}
        catch (IOException iOException) {
            throw new NamingException("object serialization stream close() failure");
        }
        out.close();
        return byArray;
    }

    static void serialize(Attributes entry, Object obj) throws NamingException {
        entry.put(OBJECTCLASS_ATTR, TOP_ATTR);
        entry.put(OBJECTCLASS_ATTR, JOBJECT_ATTR);
        entry.put(OBJECTCLASS_ATTR, JCONTAINER_ATTR);
        entry.put(OBJECTCLASS_ATTR, JSERIALIZEDOBJ_ATTR);
        entry.put(JCLASSNAME_ATTR, obj.getClass().getName());
        entry.put(JSERIALDATA_ATTR, JavaLdapSupport.serialize(obj));
        Class<?>[] classes = obj.getClass().getClasses();
        int ii = 0;
        while (ii < classes.length) {
            entry.put(JCLASSNAMES_ATTR, classes[ii].getName());
            ++ii;
        }
    }
}

