/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.jndi;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.spi.InitialContextFactory;
import org.apache.ldap.common.exception.LdapAuthenticationNotSupportedException;
import org.apache.ldap.common.exception.LdapConfigurationException;
import org.apache.ldap.common.exception.LdapNoPermissionException;
import org.apache.ldap.common.message.LockableAttributesImpl;
import org.apache.ldap.common.message.ResultCodeEnum;
import org.apache.ldap.common.name.LdapName;
import org.apache.ldap.common.schema.AttributeType;
import org.apache.ldap.common.schema.Normalizer;
import org.apache.ldap.common.util.DateUtils;
import org.apache.ldap.common.util.StringTools;
import org.apache.ldap.server.ApplicationPartition;
import org.apache.ldap.server.ContextPartition;
import org.apache.ldap.server.ContextPartitionConfig;
import org.apache.ldap.server.PartitionNexus;
import org.apache.ldap.server.RootNexus;
import org.apache.ldap.server.SystemPartition;
import org.apache.ldap.server.db.Database;
import org.apache.ldap.server.db.DefaultSearchEngine;
import org.apache.ldap.server.db.ExpressionEnumerator;
import org.apache.ldap.server.db.ExpressionEvaluator;
import org.apache.ldap.server.db.jdbm.JdbmDatabase;
import org.apache.ldap.server.interceptor.InterceptorChain;
import org.apache.ldap.server.interceptor.InterceptorConfigBuilder;
import org.apache.ldap.server.interceptor.InterceptorContext;
import org.apache.ldap.server.jndi.DeadContext;
import org.apache.ldap.server.jndi.JndiProvider;
import org.apache.ldap.server.jndi.PartitionConfigBuilder;
import org.apache.ldap.server.jndi.ProviderNexusAspect;
import org.apache.ldap.server.jndi.ServerContext;
import org.apache.ldap.server.schema.AttributeTypeRegistry;
import org.apache.ldap.server.schema.GlobalRegistries;
import org.apache.ldap.server.schema.MatchingRuleRegistry;
import org.apache.ldap.server.schema.OidRegistry;
import org.apache.ldap.server.schema.bootstrap.BootstrapRegistries;
import org.apache.ldap.server.schema.bootstrap.BootstrapSchemaLoader;

public class CoreContextFactory
implements InitialContextFactory {
    private static final String TYPE = "java.naming.security.authentication";
    private static final String CREDS = "java.naming.security.credentials";
    protected static final String PRINCIPAL = "java.naming.security.principal";
    protected static final String ADMIN = "uid=admin,ou=system";
    protected static final Name ADMIN_NAME = SystemPartition.getAdminDn();
    public static final String DEFAULT_WKDIR = "server-work";
    protected static final String[] DEFAULT_SCHEMAS = new String[]{"org.apache.ldap.server.schema.bootstrap.CoreSchema", "org.apache.ldap.server.schema.bootstrap.CosineSchema", "org.apache.ldap.server.schema.bootstrap.ApacheSchema", "org.apache.ldap.server.schema.bootstrap.InetorgpersonSchema", "org.apache.ldap.server.schema.bootstrap.JavaSchema", "org.apache.ldap.server.schema.bootstrap.SystemSchema"};
    protected JndiProvider provider = null;
    protected Hashtable initialEnv;
    protected SystemPartition system;
    protected GlobalRegistries globalRegistries;
    protected RootNexus nexus;
    protected boolean createMode;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CoreContextFactory() {
        JndiProvider.setProviderOn(this);
    }

    void setProvider(JndiProvider provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Context getInitialContext(Hashtable env) throws NamingException {
        env = (Hashtable)env.clone();
        Context ctx = null;
        if (env.containsKey("server.operation.shutdown")) {
            if (this.provider == null) {
                return new DeadContext();
            }
            try {
                try {
                    this.provider.shutdown();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                ctx = new DeadContext();
                this.provider = null;
                this.initialEnv = null;
                throw throwable;
            }
            {
                Object var4_8 = null;
                ctx = new DeadContext();
                this.provider = null;
                this.initialEnv = null;
                return ctx;
            }
        }
        if (env.containsKey("server.operation.sync")) {
            this.provider.sync();
            return this.provider.getLdapContext(env);
        }
        this.checkSecuritySettings(env);
        if (this.isAnonymous(env)) {
            env.put(PRINCIPAL, "");
        }
        if (this.provider != null) return (ServerContext)((Object)this.provider.getLdapContext(env));
        if (this.isAnonymous(env) && env.containsKey("server.disable.anonymous")) {
            throw new LdapNoPermissionException("cannot bind as anonymous on startup while disabling anonymous binds w/ property: server.disable.anonymous");
        }
        this.initialEnv = env;
        this.initialize();
        this.createMode = this.createBootstrapEntries();
        if (!this.createMode) return (ServerContext)((Object)this.provider.getLdapContext(env));
        if (!env.containsKey("server.test.entries")) return (ServerContext)((Object)this.provider.getLdapContext(env));
        ArrayList list = (ArrayList)this.initialEnv.get("server.test.entries");
        if (list == null) return (ServerContext)((Object)this.provider.getLdapContext(env));
        int ii = 0;
        while (ii < list.size()) {
            Attributes attributes = (Attributes)list.get(ii);
            attributes.put("creatorsName", ADMIN);
            attributes.put("createTimestamp", DateUtils.getGeneralizedTime());
            Attribute dn = attributes.remove("dn");
            Attributes attributes2 = attributes;
            LdapName ldapName = new LdapName((String)dn.get());
            String string = (String)dn.get();
            RootNexus rootNexus = this.nexus;
            try {
                if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095((Context)((Object)this));
                }
                rootNexus.add(string, (Name)ldapName, attributes2);
            }
            finally {
                if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095((Context)((Object)this));
                }
            }
            ++ii;
        }
        return (ServerContext)((Object)this.provider.getLdapContext(env));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkSecuritySettings(Hashtable env) throws NamingException {
        if (env.containsKey(TYPE) && env.get(TYPE) != null) {
            if (env.get(TYPE).equals("simple")) {
                if (!env.containsKey(CREDS)) {
                    throw new LdapConfigurationException("missing required java.naming.security.credentials property for simple authentication");
                }
                if (env.containsKey(PRINCIPAL)) return;
                throw new LdapConfigurationException("missing required java.naming.security.principal property for simple authentication");
            }
            if (!env.get(TYPE).equals("none")) throw new LdapAuthenticationNotSupportedException(ResultCodeEnum.AUTHMETHODNOTSUPPORTED);
            if (env.containsKey(CREDS)) {
                throw new LdapConfigurationException("ambiguous bind settings encountered where bind is anonymous yet java.naming.security.credentials property is set");
            }
            if (!env.containsKey(PRINCIPAL)) return;
            throw new LdapConfigurationException("ambiguous bind settings encountered where bind is anonymous yet java.naming.security.principal property is set");
        }
        if (!env.containsKey(CREDS) || env.containsKey(PRINCIPAL)) return;
        throw new LdapConfigurationException("credentials provided without principal name property: java.naming.security.principal");
    }

    protected boolean isAnonymous(Hashtable env) {
        if (env.containsKey(TYPE) && env.get(TYPE) != null) {
            return env.get(TYPE).equals("none");
        }
        return !env.containsKey(CREDS);
    }

    private boolean createBootstrapEntries() throws NamingException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        LockableAttributesImpl attributes;
        boolean bl4;
        boolean isFirstStart = false;
        Name name = ADMIN_NAME;
        RootNexus rootNexus = this.nexus;
        try {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095((Context)((Object)this));
            }
            bl4 = rootNexus.hasEntry(name);
        }
        finally {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095((Context)((Object)this));
            }
        }
        if (bl4) {
            isFirstStart = false;
        } else {
            isFirstStart = true;
            attributes = new LockableAttributesImpl();
            attributes.put("objectClass", "top");
            attributes.put("objectClass", "person");
            attributes.put("objectClass", "organizationalPerson");
            attributes.put("objectClass", "inetOrgPerson");
            attributes.put("uid", "admin");
            attributes.put("userPassword", SystemPartition.ADMIN_PW);
            attributes.put("displayName", "Directory Superuser");
            attributes.put("creatorsName", ADMIN);
            attributes.put("createTimestamp", DateUtils.getGeneralizedTime());
            attributes.put("displayName", "Directory Superuser");
            LockableAttributesImpl lockableAttributesImpl = attributes;
            Name name2 = ADMIN_NAME;
            String string = ADMIN;
            RootNexus rootNexus2 = this.nexus;
            try {
                if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus2 instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095((Context)((Object)this));
                }
                rootNexus2.add(string, name2, (Attributes)lockableAttributesImpl);
            }
            finally {
                if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus2 instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095((Context)((Object)this));
                }
            }
        }
        LdapName ldapName = new LdapName("ou=users,ou=system");
        RootNexus rootNexus3 = this.nexus;
        try {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus3 instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095((Context)((Object)this));
            }
            bl3 = rootNexus3.hasEntry((Name)ldapName);
        }
        finally {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus3 instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095((Context)((Object)this));
            }
        }
        if (bl3) {
            isFirstStart = false;
        } else {
            isFirstStart = true;
            attributes = new LockableAttributesImpl();
            attributes.put("objectClass", "top");
            attributes.put("objectClass", "organizationalUnit");
            attributes.put("ou", "users");
            attributes.put("creatorsName", ADMIN);
            attributes.put("createTimestamp", DateUtils.getGeneralizedTime());
            LockableAttributesImpl lockableAttributesImpl = attributes;
            LdapName ldapName2 = new LdapName("ou=users,ou=system");
            String string = "ou=users,ou=system";
            RootNexus rootNexus4 = this.nexus;
            try {
                if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus4 instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095((Context)((Object)this));
                }
                rootNexus4.add(string, (Name)ldapName2, (Attributes)lockableAttributesImpl);
            }
            finally {
                if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus4 instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095((Context)((Object)this));
                }
            }
        }
        LdapName ldapName3 = new LdapName("ou=groups,ou=system");
        RootNexus rootNexus5 = this.nexus;
        try {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus5 instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095((Context)((Object)this));
            }
            bl2 = rootNexus5.hasEntry((Name)ldapName3);
        }
        finally {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus5 instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095((Context)((Object)this));
            }
        }
        if (bl2) {
            isFirstStart = false;
        } else {
            isFirstStart = true;
            attributes = new LockableAttributesImpl();
            attributes.put("objectClass", "top");
            attributes.put("objectClass", "organizationalUnit");
            attributes.put("ou", "groups");
            attributes.put("creatorsName", ADMIN);
            attributes.put("createTimestamp", DateUtils.getGeneralizedTime());
            LockableAttributesImpl lockableAttributesImpl = attributes;
            LdapName ldapName4 = new LdapName("ou=groups,ou=system");
            String string = "ou=groups,ou=system";
            RootNexus rootNexus6 = this.nexus;
            try {
                if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus6 instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095((Context)((Object)this));
                }
                rootNexus6.add(string, (Name)ldapName4, (Attributes)lockableAttributesImpl);
            }
            finally {
                if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus6 instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095((Context)((Object)this));
                }
            }
        }
        LdapName ldapName5 = new LdapName("prefNodeName=sysPrefRoot,ou=system");
        RootNexus rootNexus7 = this.nexus;
        try {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus7 instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095((Context)((Object)this));
            }
            bl = rootNexus7.hasEntry((Name)ldapName5);
        }
        finally {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus7 instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095((Context)((Object)this));
            }
        }
        if (bl) {
            isFirstStart = false;
        } else {
            isFirstStart = true;
            attributes = new LockableAttributesImpl();
            attributes.put("objectClass", "top");
            attributes.put("objectClass", "prefNode");
            attributes.put("objectClass", "extensibleObject");
            attributes.put("prefNodeName", "sysPrefRoot");
            attributes.put("creatorsName", ADMIN);
            attributes.put("createTimestamp", DateUtils.getGeneralizedTime());
            LdapName dn = new LdapName("prefNodeName=sysPrefRoot,ou=system");
            LockableAttributesImpl lockableAttributesImpl = attributes;
            LdapName ldapName6 = dn;
            String string = "prefNodeName=sysPrefRoot,ou=system";
            RootNexus rootNexus8 = this.nexus;
            try {
                if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus8 instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095((Context)((Object)this));
                }
                rootNexus8.add(string, (Name)ldapName6, (Attributes)lockableAttributesImpl);
            }
            finally {
                if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus8 instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095((Context)((Object)this));
                }
            }
        }
        return isFirstStart;
    }

    protected void initialize() throws NamingException {
        File wkdirFile;
        BootstrapRegistries bootstrapRegistries = new BootstrapRegistries();
        BootstrapSchemaLoader loader = new BootstrapSchemaLoader();
        String[] schemas = DEFAULT_SCHEMAS;
        if (this.initialEnv.containsKey("server.schemas")) {
            String schemaList = (String)this.initialEnv.get("server.schemas");
            schemaList = StringTools.deepTrim((String)schemaList);
            schemas = schemaList.split(" ");
            int ii = 0;
            while (ii < schemas.length) {
                schemas[ii] = schemas[ii].trim();
                ++ii;
            }
        }
        loader.load(schemas, bootstrapRegistries);
        List errors = bootstrapRegistries.checkRefInteg();
        if (!errors.isEmpty()) {
            NamingException e = new NamingException();
            e.setRootCause((Throwable)errors.get(0));
            throw e;
        }
        String wkdir = DEFAULT_WKDIR;
        if (this.initialEnv.containsKey("server.wkdir")) {
            wkdir = ((String)this.initialEnv.get("server.wkdir")).trim();
        }
        if ((wkdirFile = new File(wkdir)).isAbsolute()) {
            if (!wkdirFile.exists()) {
                throw new NamingException("working directory " + wkdir + " does not exist");
            }
        } else {
            File current = new File(".");
            this.mkdirs(current.getAbsolutePath(), wkdir);
        }
        LdapName suffix = new LdapName();
        suffix.add("ou=system");
        JdbmDatabase db = new JdbmDatabase((Name)suffix, (Name)suffix, wkdir);
        AttributeTypeRegistry attributeTypeRegistry = bootstrapRegistries.getAttributeTypeRegistry();
        OidRegistry oidRegistry = bootstrapRegistries.getOidRegistry();
        ExpressionEvaluator evaluator = new ExpressionEvaluator(db, oidRegistry, attributeTypeRegistry);
        ExpressionEnumerator enumerator = new ExpressionEnumerator(db, attributeTypeRegistry, evaluator);
        DefaultSearchEngine eng = new DefaultSearchEngine(db, evaluator, enumerator);
        AttributeType[] attributes = new AttributeType[]{attributeTypeRegistry.lookup("1.2.6.1.4.1.18060.1.1.1.3.7"), attributeTypeRegistry.lookup("1.2.6.1.4.1.18060.1.1.1.3.3"), attributeTypeRegistry.lookup("1.2.6.1.4.1.18060.1.1.1.3.4"), attributeTypeRegistry.lookup("1.2.6.1.4.1.18060.1.1.1.3.1"), attributeTypeRegistry.lookup("1.2.6.1.4.1.18060.1.1.1.3.5"), attributeTypeRegistry.lookup("1.2.6.1.4.1.18060.1.1.1.3.6"), attributeTypeRegistry.lookup("1.2.6.1.4.1.18060.1.1.1.3.2")};
        this.system = new SystemPartition(db, eng, attributes);
        this.globalRegistries = new GlobalRegistries(this.system, bootstrapRegistries);
        this.nexus = new RootNexus(this.system, (Attributes)new LockableAttributesImpl());
        this.provider = new JndiProvider(this.nexus);
        InterceptorChain interceptor = (InterceptorChain)this.initialEnv.get("server.interceptor");
        if (interceptor == null) {
            interceptor = InterceptorChain.newDefaultChain();
        }
        interceptor.init(new InterceptorContext(this.initialEnv, this.system, this.globalRegistries, this.nexus, InterceptorConfigBuilder.build(this.initialEnv, "server.interceptor")));
        this.provider.setInterceptor(interceptor);
        if (this.initialEnv.get("server.db.partitions") != null) {
            this.startUpAppPartitions(wkdir);
        }
    }

    protected void startUpAppPartitions(String eveWkdir) throws NamingException {
        OidRegistry oidRegistry = this.globalRegistries.getOidRegistry();
        AttributeTypeRegistry attributeTypeRegistry = this.globalRegistries.getAttributeTypeRegistry();
        MatchingRuleRegistry reg = this.globalRegistries.getMatchingRuleRegistry();
        ContextPartitionConfig[] configs = null;
        configs = PartitionConfigBuilder.getContextPartitionConfigs(this.initialEnv);
        int ii = 0;
        while (ii < configs.length) {
            String wkdir = String.valueOf(eveWkdir) + File.separator + configs[ii].getId();
            this.mkdirs(eveWkdir, configs[ii].getId());
            LdapName upSuffix = new LdapName(configs[ii].getSuffix());
            Normalizer dnNorm = reg.lookup("distinguishedNameMatch").getNormalizer();
            LdapName normSuffix = new LdapName((String)dnNorm.normalize((Object)configs[ii].getSuffix()));
            JdbmDatabase db = new JdbmDatabase((Name)upSuffix, (Name)normSuffix, wkdir);
            ExpressionEvaluator evaluator = new ExpressionEvaluator(db, oidRegistry, attributeTypeRegistry);
            ExpressionEnumerator enumerator = new ExpressionEnumerator(db, attributeTypeRegistry, evaluator);
            DefaultSearchEngine eng = new DefaultSearchEngine(db, evaluator, enumerator);
            ArrayList<AttributeType> attributeTypeList = new ArrayList<AttributeType>();
            attributeTypeList.add(attributeTypeRegistry.lookup("1.2.6.1.4.1.18060.1.1.1.3.7"));
            attributeTypeList.add(attributeTypeRegistry.lookup("1.2.6.1.4.1.18060.1.1.1.3.3"));
            attributeTypeList.add(attributeTypeRegistry.lookup("1.2.6.1.4.1.18060.1.1.1.3.4"));
            attributeTypeList.add(attributeTypeRegistry.lookup("1.2.6.1.4.1.18060.1.1.1.3.1"));
            attributeTypeList.add(attributeTypeRegistry.lookup("1.2.6.1.4.1.18060.1.1.1.3.5"));
            attributeTypeList.add(attributeTypeRegistry.lookup("1.2.6.1.4.1.18060.1.1.1.3.6"));
            attributeTypeList.add(attributeTypeRegistry.lookup("1.2.6.1.4.1.18060.1.1.1.3.2"));
            int jj = 0;
            while (jj < configs[ii].getIndices().length) {
                attributeTypeList.add(attributeTypeRegistry.lookup(configs[ii].getIndices()[jj]));
                ++jj;
            }
            AttributeType[] indexTypes = attributeTypeList.toArray(new AttributeType[attributeTypeList.size()]);
            String partitionClass = configs[ii].getPartitionClass();
            String properties = configs[ii].getProperties();
            ContextPartition partition = null;
            if (partitionClass == null) {
                partition = new ApplicationPartition((Name)upSuffix, (Name)normSuffix, db, eng, indexTypes);
            } else {
                try {
                    Class<?> clazz = Class.forName(partitionClass);
                    Class[] classArray = new Class[3];
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName("javax.naming.Name");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz2;
                    Class<?> clazz3 = class$0;
                    if (clazz3 == null) {
                        try {
                            clazz3 = Class.forName("javax.naming.Name");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[1] = clazz3;
                    Class<?> clazz4 = class$1;
                    if (clazz4 == null) {
                        try {
                            clazz4 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[2] = clazz4;
                    Constructor<?> constructor = clazz.getConstructor(classArray);
                    partition = (ContextPartition)constructor.newInstance(upSuffix, normSuffix, properties);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (partition != null) {
                this.nexus.register(partition);
            }
            Attributes attributes = configs[ii].getAttributes();
            LdapName ldapName = normSuffix;
            String string = configs[ii].getSuffix();
            ApplicationPartition applicationPartition = partition;
            try {
                if (this instanceof Context && !(this instanceof ContextPartition) && applicationPartition instanceof PartitionNexus && !(applicationPartition instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095((Context)((Object)this));
                }
                applicationPartition.add(string, (Name)ldapName, attributes);
            }
            finally {
                if (this instanceof Context && !(this instanceof ContextPartition) && applicationPartition instanceof PartitionNexus && !(applicationPartition instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095((Context)((Object)this));
                }
            }
            ++ii;
        }
    }

    protected boolean mkdirs(String base, String path) {
        String[] comps = path.split("/");
        File file = new File(base);
        if (!file.exists()) {
            file.mkdirs();
        }
        int ii = 0;
        while (ii < comps.length) {
            if (!(file = new File(file, comps[ii])).exists()) {
                file.mkdirs();
            }
            ++ii;
        }
        return file.exists();
    }
}

