/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.interceptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.ldap.server.authn.AuthenticationService;
import org.apache.ldap.server.authz.AuthorizationService;
import org.apache.ldap.server.exception.ExceptionService;
import org.apache.ldap.server.interceptor.Interceptor;
import org.apache.ldap.server.interceptor.InterceptorConfigBuilder;
import org.apache.ldap.server.interceptor.InterceptorContext;
import org.apache.ldap.server.interceptor.InterceptorException;
import org.apache.ldap.server.interceptor.NextInterceptor;
import org.apache.ldap.server.invocation.Invocation;
import org.apache.ldap.server.normalization.NormalizationService;
import org.apache.ldap.server.operational.OperationalAttributeService;
import org.apache.ldap.server.schema.SchemaService;

public class InterceptorChain
implements Interceptor {
    public static final String NEXT_INTERCEPTOR = "nextInterceptor";
    private final Interceptor NEXT_INTERCEPTOR0 = new Interceptor(){

        public void init(InterceptorContext context) {
        }

        public void destroy() {
        }

        public void process(NextInterceptor nextInterceptor, Invocation invocation) throws NamingException {
            if (InterceptorChain.this.parent != null) {
                Entry e = (Entry)InterceptorChain.this.parent.interceptor2entry.get(InterceptorChain.this);
                e.nextInterceptor.process(invocation);
            }
            nextInterceptor.process(invocation);
        }
    };
    private final Interceptor FINAL_INTERCEPTOR = new Interceptor(){
        private InterceptorContext ctx;

        public void init(InterceptorContext context) {
            this.ctx = context;
        }

        public void destroy() {
        }

        public void process(NextInterceptor nextInterceptor, Invocation call) throws NamingException {
            if (InterceptorChain.this.parent == null) {
                call.execute(this.ctx.getRootNexus());
            }
        }
    };
    private InterceptorChain parent;
    private final Map name2entry = new HashMap();
    private final Map interceptor2entry = new IdentityHashMap();
    private Entry head = new Entry(null, null, "nextInterceptor", this.NEXT_INTERCEPTOR0);
    private final Entry tail = new Entry(null, null, "end", this.FINAL_INTERCEPTOR);

    public static InterceptorChain newDefaultChain() {
        InterceptorChain chain = new InterceptorChain();
        chain.addFirst("normalizationService", new NormalizationService());
        chain.addBefore(NEXT_INTERCEPTOR, "authenticationService", new AuthenticationService());
        chain.addBefore(NEXT_INTERCEPTOR, "authorizationService", new AuthorizationService());
        chain.addBefore(NEXT_INTERCEPTOR, "exceptionService", new ExceptionService());
        chain.addBefore(NEXT_INTERCEPTOR, "schemaService", new SchemaService());
        chain.addBefore(NEXT_INTERCEPTOR, "operationalAttributeService", new OperationalAttributeService());
        return chain;
    }

    public InterceptorChain() {
        this.head.nextEntry = this.tail;
        this.tail.prevEntry = this.head;
        this.register(NEXT_INTERCEPTOR, this.head);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void init(InterceptorContext ctx) throws NamingException {
        block7: {
            it = this.getAll().listIterator();
            interceptor = null;
            try {
                while (it.hasNext()) {
                    interceptor = (Interceptor)it.next();
                    name = this.getName(interceptor);
                    config = InterceptorConfigBuilder.build(ctx.getConfig(), name == null ? "" : name);
                    newCtx = new InterceptorContext(ctx.getEnvironment(), ctx.getSystemPartition(), ctx.getGlobalRegistries(), ctx.getRootNexus(), config);
                    interceptor.init(newCtx);
                }
                break block7;
            }
            catch (Throwable t) {
                ** while (it.hasPrevious())
            }
lbl-1000:
            // 1 sources

            {
                i = (Interceptor)it.previous();
                try {
                    i.destroy();
                }
                catch (Throwable t2) {
                    t2.printStackTrace();
                }
                continue;
            }
lbl21:
            // 1 sources

            if (t instanceof NamingException) {
                throw (NamingException)t;
            }
            throw new InterceptorException(interceptor, null, "Failed to initialize interceptor chain.", t);
        }
    }

    public synchronized void destroy() {
        ListIterator it = this.getAllReversed().listIterator();
        while (it.hasNext()) {
            Interceptor interceptor = (Interceptor)it.next();
            try {
                interceptor.destroy();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public Interceptor get(String name) {
        Entry e = (Entry)this.name2entry.get(name);
        if (e == null) {
            return null;
        }
        return e.interceptor;
    }

    private String getName(Interceptor interceptor) {
        Entry e = (Entry)this.interceptor2entry.get(interceptor);
        if (e == null) {
            return null;
        }
        return e.name;
    }

    public synchronized void addFirst(String name, Interceptor interceptor) {
        this.checkAddable(name, interceptor);
        Entry newEntry = new Entry(null, this.head, name, interceptor);
        this.head.prevEntry = newEntry;
        this.head = newEntry;
        this.register(name, newEntry);
    }

    public synchronized void addLast(String name, Interceptor interceptor) {
        this.checkAddable(name, interceptor);
        Entry newEntry = new Entry(this.tail.prevEntry, this.tail, name, interceptor);
        if (this.tail.prevEntry != null) {
            this.tail.prevEntry.nextEntry = newEntry;
        } else {
            this.head = newEntry;
        }
        this.tail.prevEntry = newEntry;
        this.register(name, newEntry);
    }

    public synchronized void addBefore(String baseName, String name, Interceptor interceptor) {
        Entry baseEntry = this.checkOldName(baseName);
        this.checkAddable(name, interceptor);
        Entry prevEntry = baseEntry.prevEntry;
        Entry newEntry = new Entry(prevEntry, baseEntry, name, interceptor);
        if (prevEntry == null) {
            baseEntry.prevEntry = newEntry;
            this.head = newEntry;
        } else {
            baseEntry.prevEntry = newEntry;
            prevEntry.nextEntry = newEntry;
        }
        this.register(name, newEntry);
    }

    public synchronized void addAfter(String baseName, String name, Interceptor interceptor) {
        Entry baseEntry = this.checkOldName(baseName);
        this.checkAddable(name, interceptor);
        Entry nextEntry = baseEntry.nextEntry;
        Entry newEntry = new Entry(baseEntry, nextEntry, name, interceptor);
        if (nextEntry == null) {
            throw new IllegalStateException();
        }
        nextEntry.prevEntry.nextEntry = newEntry;
        nextEntry.prevEntry = newEntry;
        this.register(name, newEntry);
    }

    public synchronized void remove(String name) {
        Entry entry = this.checkOldName(name);
        Entry prevEntry = entry.prevEntry;
        Entry nextEntry = entry.nextEntry;
        if (prevEntry == null) {
            nextEntry.prevEntry = null;
            this.head = entry;
        } else {
            prevEntry.nextEntry = nextEntry;
            nextEntry.prevEntry = prevEntry;
        }
        this.name2entry.remove(name);
        Interceptor interceptor = entry.interceptor;
        this.interceptor2entry.remove(interceptor);
        if (interceptor instanceof InterceptorChain) {
            ((InterceptorChain)interceptor).parent = null;
        }
    }

    public synchronized void clear() {
        Iterator it = new ArrayList(this.name2entry.keySet()).iterator();
        while (it.hasNext()) {
            this.remove((String)it.next());
        }
    }

    private void register(String name, Entry newEntry) {
        Interceptor interceptor = newEntry.interceptor;
        this.name2entry.put(name, newEntry);
        this.interceptor2entry.put(newEntry.interceptor, newEntry);
        if (interceptor instanceof InterceptorChain) {
            ((InterceptorChain)interceptor).parent = this;
        }
    }

    private Entry checkOldName(String baseName) {
        Entry e = (Entry)this.name2entry.get(baseName);
        if (e == null) {
            throw new IllegalArgumentException("Unknown interceptor name:" + baseName);
        }
        return e;
    }

    private void checkAddable(String name, Interceptor interceptor) {
        if (this.name2entry.containsKey(name)) {
            throw new IllegalArgumentException("Other interceptor is using name '" + name + "'");
        }
        if (interceptor instanceof InterceptorChain && ((InterceptorChain)interceptor).parent != null) {
            throw new IllegalArgumentException("This interceptor chain has its parent already.");
        }
    }

    public void process(NextInterceptor nextInterceptor, Invocation invocation) throws NamingException {
        Entry head = this.head;
        try {
            head.interceptor.process(head.nextInterceptor, invocation);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            throw new InterceptorException(head.interceptor, invocation, "Unexpected exception.", e);
        }
    }

    public List getAll() {
        ArrayList<Interceptor> list = new ArrayList<Interceptor>();
        Entry e = this.head;
        do {
            list.add(e.interceptor);
        } while ((e = e.nextEntry) != null);
        return list;
    }

    public List getAllReversed() {
        ArrayList<Interceptor> list = new ArrayList<Interceptor>();
        Entry e = this.tail;
        do {
            list.add(e.interceptor);
        } while ((e = e.prevEntry) != null);
        return list;
    }

    private class Entry {
        private Entry prevEntry;
        private Entry nextEntry;
        private final String name;
        private final Interceptor interceptor;
        private final NextInterceptor nextInterceptor;

        Entry(Entry prevEntry, Entry nextEntry, String name, Interceptor interceptor) {
            if (interceptor == null) {
                throw new NullPointerException("interceptor");
            }
            if (name == null) {
                throw new NullPointerException("name");
            }
            this.prevEntry = prevEntry;
            this.nextEntry = nextEntry;
            this.name = name;
            this.interceptor = interceptor;
            this.nextInterceptor = new NextInterceptor(this){
                final /* synthetic */ Entry this$1;
                {
                    this.this$1 = entry;
                }

                public void process(Invocation call) throws NamingException {
                    Interceptor interceptor = Entry.access$2(Entry.access$1(this.this$1));
                    try {
                        interceptor.process(Entry.access$0(Entry.access$1(this.this$1)), call);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        throw new InterceptorException(interceptor, call, "Unexpected exception.", e);
                    }
                }
            };
        }
    }
}

