/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.interceptor;

import javax.naming.NamingException;
import org.apache.ldap.server.authn.LdapPrincipal;
import org.apache.ldap.server.interceptor.Interceptor;
import org.apache.ldap.server.interceptor.NextInterceptor;
import org.apache.ldap.server.invocation.Add;
import org.apache.ldap.server.invocation.Delete;
import org.apache.ldap.server.invocation.GetMatchedDN;
import org.apache.ldap.server.invocation.GetSuffix;
import org.apache.ldap.server.invocation.HasEntry;
import org.apache.ldap.server.invocation.Invocation;
import org.apache.ldap.server.invocation.IsSuffix;
import org.apache.ldap.server.invocation.List;
import org.apache.ldap.server.invocation.ListSuffixes;
import org.apache.ldap.server.invocation.Lookup;
import org.apache.ldap.server.invocation.LookupWithAttrIds;
import org.apache.ldap.server.invocation.Modify;
import org.apache.ldap.server.invocation.ModifyMany;
import org.apache.ldap.server.invocation.ModifyRN;
import org.apache.ldap.server.invocation.Move;
import org.apache.ldap.server.invocation.MoveAndModifyRN;
import org.apache.ldap.server.invocation.Search;
import org.apache.ldap.server.jndi.ServerContext;

public abstract class BaseInterceptor
implements Interceptor {
    public static LdapPrincipal getPrincipal(Invocation call) {
        ServerContext ctx = (ServerContext)call.getContextStack().peek();
        return ctx.getPrincipal();
    }

    protected BaseInterceptor() {
    }

    public void process(NextInterceptor nextInterceptor, Invocation call) throws NamingException {
        if (call instanceof Add) {
            this.process(nextInterceptor, (Add)call);
        } else if (call instanceof Delete) {
            this.process(nextInterceptor, (Delete)call);
        } else if (call instanceof GetMatchedDN) {
            this.process(nextInterceptor, (GetMatchedDN)call);
        } else if (call instanceof GetSuffix) {
            this.process(nextInterceptor, (GetSuffix)call);
        } else if (call instanceof HasEntry) {
            this.process(nextInterceptor, (HasEntry)call);
        } else if (call instanceof IsSuffix) {
            this.process(nextInterceptor, (IsSuffix)call);
        } else if (call instanceof List) {
            this.process(nextInterceptor, (List)call);
        } else if (call instanceof ListSuffixes) {
            this.process(nextInterceptor, (ListSuffixes)call);
        } else if (call instanceof Lookup) {
            this.process(nextInterceptor, (Lookup)call);
        } else if (call instanceof LookupWithAttrIds) {
            this.process(nextInterceptor, (LookupWithAttrIds)call);
        } else if (call instanceof Modify) {
            this.process(nextInterceptor, (Modify)call);
        } else if (call instanceof ModifyMany) {
            this.process(nextInterceptor, (ModifyMany)call);
        } else if (call instanceof ModifyRN) {
            this.process(nextInterceptor, (ModifyRN)call);
        } else if (call instanceof Move) {
            this.process(nextInterceptor, (Move)call);
        } else if (call instanceof MoveAndModifyRN) {
            this.process(nextInterceptor, (MoveAndModifyRN)call);
        } else if (call instanceof Search) {
            this.process(nextInterceptor, (Search)call);
        } else {
            throw new IllegalArgumentException("Unknown call type: " + call.getClass());
        }
    }

    protected void process(NextInterceptor nextInterceptor, Add call) throws NamingException {
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, Delete call) throws NamingException {
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, GetMatchedDN call) throws NamingException {
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, GetSuffix call) throws NamingException {
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, HasEntry call) throws NamingException {
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, IsSuffix call) throws NamingException {
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, List call) throws NamingException {
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, ListSuffixes call) throws NamingException {
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, Lookup call) throws NamingException {
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, LookupWithAttrIds call) throws NamingException {
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, Modify call) throws NamingException {
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, ModifyMany call) throws NamingException {
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, ModifyRN call) throws NamingException {
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, Move call) throws NamingException {
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, MoveAndModifyRN call) throws NamingException {
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, Search call) throws NamingException {
        nextInterceptor.process(call);
    }
}

