/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.exception;

import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.ldap.common.exception.LdapContextNotEmptyException;
import org.apache.ldap.common.exception.LdapNameAlreadyBoundException;
import org.apache.ldap.common.exception.LdapNameNotFoundException;
import org.apache.ldap.common.exception.LdapNamingException;
import org.apache.ldap.common.message.ResultCodeEnum;
import org.apache.ldap.common.name.LdapName;
import org.apache.ldap.server.ContextPartition;
import org.apache.ldap.server.RootNexus;
import org.apache.ldap.server.db.Database;
import org.apache.ldap.server.interceptor.BaseInterceptor;
import org.apache.ldap.server.interceptor.InterceptorContext;
import org.apache.ldap.server.interceptor.NextInterceptor;
import org.apache.ldap.server.invocation.Add;
import org.apache.ldap.server.invocation.Delete;
import org.apache.ldap.server.invocation.List;
import org.apache.ldap.server.invocation.Lookup;
import org.apache.ldap.server.invocation.LookupWithAttrIds;
import org.apache.ldap.server.invocation.Modify;
import org.apache.ldap.server.invocation.ModifyMany;
import org.apache.ldap.server.invocation.ModifyRN;
import org.apache.ldap.server.invocation.Move;
import org.apache.ldap.server.invocation.MoveAndModifyRN;
import org.apache.ldap.server.invocation.Search;
import org.apache.ldap.server.jndi.ProviderNexusAspect;

public class ExceptionService
extends BaseInterceptor {
    private RootNexus nexus;

    public void init(InterceptorContext ctx) {
        this.nexus = ctx.getRootNexus();
    }

    public void destroy() {
    }

    protected void process(NextInterceptor nextInterceptor, Add call) throws NamingException {
        Attributes attributes;
        boolean bl;
        Name normName = call.getNormalizedName();
        String upName = call.getUserProvidedName();
        Name name = normName;
        RootNexus rootNexus = this.nexus;
        try {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095((Context)((Object)this));
            }
            bl = rootNexus.hasEntry(name);
        }
        finally {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095((Context)((Object)this));
            }
        }
        if (bl) {
            LdapNameAlreadyBoundException ne = new LdapNameAlreadyBoundException();
            ne.setResolvedName((Name)new LdapName(upName));
            throw ne;
        }
        Object parentDn = new LdapName(upName);
        parentDn = parentDn.getSuffix(1);
        this.assertHasEntry("Attempt to add under non-existant parent: ", (Name)parentDn);
        Name name2 = normName.getSuffix(1);
        RootNexus rootNexus2 = this.nexus;
        try {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus2 instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095((Context)((Object)this));
            }
            attributes = rootNexus2.lookup(name2);
        }
        finally {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus2 instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095((Context)((Object)this));
            }
        }
        Attributes attrs = attributes;
        Attribute objectClass = attrs.get("objectClass");
        if (objectClass.contains("alias")) {
            String msg = "Attempt to add entry to alias '" + upName + "' not allowed.";
            ResultCodeEnum rc = ResultCodeEnum.ALIASPROBLEM;
            LdapNamingException e = new LdapNamingException(msg, rc);
            e.setResolvedName((Name)parentDn);
            throw e;
        }
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, Delete call) throws NamingException {
        NamingEnumeration namingEnumeration;
        Name name = call.getName();
        String msg = "Attempt to delete non-existant entry: ";
        this.assertHasEntry(msg, name);
        boolean hasChildren = false;
        Name name2 = name;
        RootNexus rootNexus = this.nexus;
        try {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095((Context)((Object)this));
            }
            namingEnumeration = rootNexus.list(name2);
        }
        finally {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095((Context)((Object)this));
            }
        }
        NamingEnumeration list = namingEnumeration;
        if (list.hasMore()) {
            hasChildren = true;
        }
        list.close();
        if (hasChildren) {
            LdapContextNotEmptyException e = new LdapContextNotEmptyException();
            e.setResolvedName(name);
            throw e;
        }
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, List call) throws NamingException {
        String msg = "Attempt to search under non-existant entry: ";
        this.assertHasEntry(msg, call.getBaseName());
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, Lookup call) throws NamingException {
        String msg = "Attempt to lookup non-existant entry: ";
        this.assertHasEntry(msg, call.getName());
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, LookupWithAttrIds call) throws NamingException {
        String msg = "Attempt to lookup non-existant entry: ";
        this.assertHasEntry(msg, call.getName());
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, Modify call) throws NamingException {
        String msg = "Attempt to modify non-existant entry: ";
        this.assertHasEntry(msg, call.getName());
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, ModifyMany call) throws NamingException {
        String msg = "Attempt to modify non-existant entry: ";
        this.assertHasEntry(msg, call.getName());
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, ModifyRN call) throws NamingException {
        boolean bl;
        Name target;
        Name dn = call.getName();
        String newRdn = call.getNewRelativeName();
        String msg = "Attempt to rename non-existant entry: ";
        this.assertHasEntry(msg, dn);
        Name name = target = dn.getSuffix(1).add(newRdn);
        RootNexus rootNexus = this.nexus;
        try {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095((Context)((Object)this));
            }
            bl = rootNexus.hasEntry(name);
        }
        finally {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095((Context)((Object)this));
            }
        }
        if (bl) {
            LdapNameAlreadyBoundException e = null;
            e = new LdapNameAlreadyBoundException("target entry " + target + " already exists!");
            e.setResolvedName(target);
            throw e;
        }
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, Move call) throws NamingException {
        boolean bl;
        String msg = "Attempt to move to non-existant parent: ";
        this.assertHasEntry(msg, call.getName());
        msg = "Attempt to move to non-existant parent: ";
        this.assertHasEntry(msg, call.getNewParentName());
        String rdn = call.getName().get(call.getName().size() - 1);
        Name target = (Name)call.getNewParentName().clone();
        target.add(rdn);
        Name name = target;
        RootNexus rootNexus = this.nexus;
        try {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095((Context)((Object)this));
            }
            bl = rootNexus.hasEntry(name);
        }
        finally {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095((Context)((Object)this));
            }
        }
        if (bl) {
            LdapNameAlreadyBoundException e = null;
            e = new LdapNameAlreadyBoundException("target entry " + target + " already exists!");
            e.setResolvedName(target);
            throw e;
        }
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, MoveAndModifyRN call) throws NamingException {
        boolean bl;
        String msg = "Attempt to move to non-existant parent: ";
        this.assertHasEntry(msg, call.getName());
        msg = "Attempt to move to non-existant parent: ";
        this.assertHasEntry(msg, call.getNewParentName());
        Name target = (Name)call.getNewParentName().clone();
        target.add(call.getNewRelativeName());
        Name name = target;
        RootNexus rootNexus = this.nexus;
        try {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095((Context)((Object)this));
            }
            bl = rootNexus.hasEntry(name);
        }
        finally {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095((Context)((Object)this));
            }
        }
        if (bl) {
            LdapNameAlreadyBoundException e = null;
            e = new LdapNameAlreadyBoundException("target entry " + target + " already exists!");
            e.setResolvedName(target);
            throw e;
        }
        nextInterceptor.process(call);
    }

    protected void process(NextInterceptor nextInterceptor, Search call) throws NamingException {
        String msg = "Attempt to search under non-existant entry: ";
        Name base = call.getBaseName();
        if (base.size() == 0) {
            nextInterceptor.process(call);
            return;
        }
        Attribute attr = this.nexus.getRootDSE().get("subschemaSubentry");
        if (((String)attr.get()).equalsIgnoreCase(base.toString())) {
            nextInterceptor.process(call);
            return;
        }
        this.assertHasEntry(msg, base);
        nextInterceptor.process(call);
    }

    private void assertHasEntry(String msg, Name dn) throws NamingException {
        boolean bl;
        Name name = dn;
        RootNexus rootNexus = this.nexus;
        try {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095((Context)((Object)this));
            }
            bl = rootNexus.hasEntry(name);
        }
        finally {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095((Context)((Object)this));
            }
        }
        if (!bl) {
            Name name2;
            LdapNameNotFoundException e = null;
            e = msg != null ? new LdapNameNotFoundException(String.valueOf(msg) + dn) : new LdapNameNotFoundException(dn.toString());
            boolean bl2 = false;
            Name name3 = dn;
            RootNexus rootNexus2 = this.nexus;
            try {
                if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus2 instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095((Context)((Object)this));
                }
                name2 = rootNexus2.getMatchedDn(name3, bl2);
            }
            finally {
                if (this instanceof Context && !(this instanceof ContextPartition) && !(rootNexus2 instanceof Database)) {
                    ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095((Context)((Object)this));
                }
            }
            e.setResolvedName(name2);
            throw e;
        }
    }
}

