/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.db;

import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.ldap.server.db.IndexRecord;
import org.apache.ldap.server.db.Tuple;
import org.apache.regexp.RE;

public class IndexEnumeration
implements NamingEnumeration {
    private final RE re;
    private final IndexRecord tmp = new IndexRecord();
    private final IndexRecord returned = new IndexRecord();
    private final IndexRecord prefetched = new IndexRecord();
    private final boolean swapKeyVal;
    private final NamingEnumeration underlying;
    private boolean hasMore = true;

    public IndexEnumeration(NamingEnumeration list) throws NamingException {
        this(list, false, null);
    }

    public IndexEnumeration(NamingEnumeration list, boolean swapKeyVal) throws NamingException {
        this(list, swapKeyVal, null);
    }

    public IndexEnumeration(NamingEnumeration list, boolean swapKeyVal, RE regex) throws NamingException {
        this.re = regex;
        this.underlying = list;
        this.swapKeyVal = swapKeyVal;
        if (!this.underlying.hasMore()) {
            this.hasMore = false;
            return;
        }
        this.prefetch();
    }

    public Object next() throws NamingException {
        this.returned.copy(this.prefetched);
        this.prefetch();
        return this.returned;
    }

    public Object nextElement() {
        try {
            return this.next();
        }
        catch (NamingException namingException) {
            throw new NoSuchElementException();
        }
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    public boolean hasMoreElements() {
        return this.hasMore;
    }

    public void close() throws NamingException {
        this.hasMore = false;
        this.underlying.close();
    }

    private void prefetch() throws NamingException {
        while (this.underlying.hasMore()) {
            Tuple tuple = (Tuple)this.underlying.next();
            if (this.swapKeyVal) {
                this.tmp.setSwapped(tuple, null);
            } else {
                this.tmp.setTuple(tuple, null);
            }
            if (this.re != null && !this.re.match((String)this.tmp.getIndexKey())) continue;
            this.prefetched.copy(this.tmp);
            return;
        }
        this.hasMore = false;
    }
}

