/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.ldap.common.MultiException;
import org.apache.ldap.common.NotImplementedException;
import org.apache.ldap.common.exception.LdapNameNotFoundException;
import org.apache.ldap.common.filter.ExprNode;
import org.apache.ldap.common.filter.PresenceNode;
import org.apache.ldap.common.message.LockableAttributeImpl;
import org.apache.ldap.common.message.LockableAttributes;
import org.apache.ldap.common.message.LockableAttributesImpl;
import org.apache.ldap.common.util.SingletonEnumeration;
import org.apache.ldap.server.BackingStore;
import org.apache.ldap.server.ContextPartition;
import org.apache.ldap.server.PartitionNexus;
import org.apache.ldap.server.SystemPartition;

public class RootNexus
implements PartitionNexus {
    private static final String ASF = "Apache Software Foundation";
    private static final String VENDORNAME_ATTR = "vendorName";
    private static final String NAMINGCTXS_ATTR = "namingContexts";
    private static RootNexus s_singleton = null;
    private boolean closed = false;
    private SystemPartition system;
    private HashMap backends = new HashMap();
    private final Attributes rootDSE;

    public RootNexus(SystemPartition system, Attributes rootDSE) {
        if (s_singleton != null) {
            throw new IllegalStateException();
        }
        s_singleton = this;
        this.system = system;
        this.rootDSE = rootDSE;
        LockableAttributeImpl attr = new LockableAttributeImpl("subschemaSubentry");
        attr.add("cn=schema,ou=system");
        rootDSE.put((Attribute)attr);
        attr = new LockableAttributeImpl("supportedLDAPVersion");
        rootDSE.put((Attribute)attr);
        attr.add("3");
        attr = new LockableAttributeImpl("objectClass");
        rootDSE.put((Attribute)attr);
        attr.add("top");
        attr.add("extensibleObject");
        attr = new LockableAttributeImpl(NAMINGCTXS_ATTR);
        rootDSE.put((Attribute)attr);
        attr = new LockableAttributeImpl(VENDORNAME_ATTR);
        attr.add(ASF);
        rootDSE.put((Attribute)attr);
        this.register(this.system);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                try {
                    if (!RootNexus.this.isClosed()) {
                        RootNexus.this.close();
                    }
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
        }, "RootNexusShutdownHook"));
    }

    public LdapContext getLdapContext() {
        throw new NotImplementedException();
    }

    public Name getMatchedDn(Name dn, boolean normalized) throws NamingException {
        dn = (Name)dn.clone();
        while (dn.size() > 0) {
            if (this.hasEntry(dn)) {
                return dn;
            }
            dn = dn.getSuffix(1);
        }
        return dn;
    }

    public Name getSuffix(Name dn, boolean normalized) throws NamingException {
        ContextPartition backend = this.getBackend(dn);
        return backend.getSuffix(normalized);
    }

    public Iterator listSuffixes(boolean normalized) throws NamingException {
        return Collections.unmodifiableSet(this.backends.keySet()).iterator();
    }

    public Attributes getRootDSE() {
        return this.rootDSE;
    }

    public void register(ContextPartition backend) {
        Attribute namingContexts = this.rootDSE.get(NAMINGCTXS_ATTR);
        namingContexts.add(backend.getSuffix(false).toString());
        this.backends.put(backend.getSuffix(true).toString(), backend);
    }

    public void unregister(ContextPartition backend) {
        Attribute namingContexts = this.rootDSE.get(NAMINGCTXS_ATTR);
        namingContexts.remove(backend.getSuffix(false).toString());
        this.backends.remove(backend.getSuffix(true).toString());
    }

    public void delete(Name dn) throws NamingException {
        ContextPartition backend = this.getBackend(dn);
        backend.delete(dn);
    }

    public void add(String updn, Name dn, Attributes an_entry) throws NamingException {
        ContextPartition backend = this.getBackend(dn);
        backend.add(updn, dn, an_entry);
    }

    public void modify(Name dn, int modOp, Attributes mods) throws NamingException {
        ContextPartition backend = this.getBackend(dn);
        backend.modify(dn, modOp, mods);
    }

    public void modify(Name dn, ModificationItem[] mods) throws NamingException {
        ContextPartition backend = this.getBackend(dn);
        backend.modify(dn, mods);
    }

    public NamingEnumeration list(Name base) throws NamingException {
        ContextPartition backend = this.getBackend(base);
        return backend.list(base);
    }

    public NamingEnumeration search(Name base, Map env, ExprNode filter, SearchControls searchCtls) throws NamingException {
        if (base.size() == 0) {
            boolean isObjectScope = searchCtls.getSearchScope() == 0;
            boolean isSearchAll = ((PresenceNode)filter).getAttribute().equalsIgnoreCase("objectclass");
            if (filter instanceof PresenceNode && isObjectScope && isSearchAll) {
                Attributes attrs = (Attributes)this.getRootDSE().clone();
                String[] ids = searchCtls.getReturningAttributes();
                if (ids != null && ids.length > 0) {
                    boolean doSwap = true;
                    LockableAttributesImpl askedFor = new LockableAttributesImpl();
                    int ii = 0;
                    while (ii < ids.length) {
                        if (ids[ii].trim().equals("*")) {
                            doSwap = false;
                            break;
                        }
                        if (attrs.get(ids[ii]) != null) {
                            askedFor.put(attrs.get(ids[ii]));
                        }
                        ++ii;
                    }
                    if (doSwap) {
                        attrs = askedFor;
                    }
                }
                SearchResult result = new SearchResult("", (Object)null, attrs, false);
                return new SingletonEnumeration((Object)result);
            }
            throw new LdapNameNotFoundException();
        }
        ContextPartition backend = this.getBackend(base);
        return backend.search(base, env, filter, searchCtls);
    }

    public Attributes lookup(Name dn) throws NamingException {
        if (dn.size() == 0) {
            LockableAttributes retval = (LockableAttributes)this.rootDSE.clone();
            retval.setLocked(true);
            return retval;
        }
        ContextPartition backend = this.getBackend(dn);
        return backend.lookup(dn);
    }

    public Attributes lookup(Name dn, String[] attrIds) throws NamingException {
        if (dn.size() == 0) {
            LockableAttributesImpl retval = new LockableAttributesImpl();
            NamingEnumeration<String> list = this.rootDSE.getIDs();
            while (list.hasMore()) {
                String id = list.next();
                Attribute attr = this.rootDSE.get(id);
                retval.put((Attribute)attr.clone());
            }
            retval.setLocked(true);
            return retval;
        }
        ContextPartition backend = this.getBackend(dn);
        return backend.lookup(dn, attrIds);
    }

    public boolean hasEntry(Name dn) throws NamingException {
        if (dn.size() == 0) {
            return true;
        }
        ContextPartition backend = this.getBackend(dn);
        return backend.hasEntry(dn);
    }

    public boolean isSuffix(Name dn) throws NamingException {
        return this.backends.containsKey(dn.toString());
    }

    public void modifyRn(Name dn, String newRdn, boolean deleteOldRdn) throws NamingException {
        ContextPartition backend = this.getBackend(dn);
        backend.modifyRn(dn, newRdn, deleteOldRdn);
    }

    public void move(Name oriChildName, Name newParentName) throws NamingException {
        ContextPartition backend = this.getBackend(oriChildName);
        backend.move(oriChildName, newParentName);
    }

    public void move(Name oldChildDn, Name newParentDn, String newRdn, boolean deleteOldRdn) throws NamingException {
        ContextPartition backend = this.getBackend(oldChildDn);
        backend.move(oldChildDn, newParentDn, newRdn, deleteOldRdn);
    }

    public void sync() throws NamingException {
        MultiException error = null;
        Iterator list = this.backends.values().iterator();
        while (list.hasNext()) {
            BackingStore store = (BackingStore)list.next();
            try {
                store.sync();
            }
            catch (NamingException e) {
                e.printStackTrace();
                if (error == null) {
                    error = new MultiException("Grouping many exceptions on root nexus sync()");
                }
                error.addThrowable((Throwable)e);
            }
        }
        if (error != null) {
            String msg = "Encountered failures while performing a sync() operation on backing stores";
            NamingException total = new NamingException(msg);
            total.setRootCause((Throwable)error);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public synchronized void close() throws NamingException {
        if (this.closed) {
            return;
        }
        MultiException error = null;
        Iterator list = this.backends.values().iterator();
        while (list.hasNext()) {
            BackingStore store = (BackingStore)list.next();
            try {
                store.sync();
                store.close();
            }
            catch (NamingException e) {
                e.printStackTrace();
                if (error == null) {
                    error = new MultiException("Grouping many exceptions on root nexus close()");
                }
                error.addThrowable((Throwable)e);
            }
        }
        s_singleton = null;
        this.closed = true;
        if (error != null) {
            String msg = "Encountered failures while performing a close() operation on backing stores";
            NamingException total = new NamingException(msg);
            total.setRootCause((Throwable)error);
            throw total;
        }
    }

    private ContextPartition getBackend(Name dn) throws NamingException {
        Name clonedDn = (Name)dn.clone();
        while (clonedDn.size() > 0) {
            if (this.backends.containsKey(clonedDn.toString())) {
                return (ContextPartition)this.backends.get(clonedDn.toString());
            }
            clonedDn.remove(clonedDn.size() - 1);
        }
        throw new NameNotFoundException();
    }
}

