/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server;

import java.math.BigInteger;
import java.util.HashSet;
import java.util.Map;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import org.apache.ldap.common.exception.LdapContextNotEmptyException;
import org.apache.ldap.common.exception.LdapNameNotFoundException;
import org.apache.ldap.common.filter.ExprNode;
import org.apache.ldap.common.message.LockableAttributesImpl;
import org.apache.ldap.common.schema.AttributeType;
import org.apache.ldap.common.util.ArrayUtils;
import org.apache.ldap.server.ContextPartition;
import org.apache.ldap.server.db.Database;
import org.apache.ldap.server.db.SearchEngine;
import org.apache.ldap.server.db.SearchResultEnumeration;
import org.apache.ldap.server.db.gui.PartitionViewer;

public abstract class AbstractContextPartition
implements ContextPartition {
    public static final String NDN_OID = "1.2.6.1.4.1.18060.1.1.1.3.1";
    public static final String UPDN_OID = "1.2.6.1.4.1.18060.1.1.1.3.2";
    public static final String EXISTANCE_OID = "1.2.6.1.4.1.18060.1.1.1.3.3";
    public static final String HIERARCHY_OID = "1.2.6.1.4.1.18060.1.1.1.3.4";
    public static final String ONEALIAS_OID = "1.2.6.1.4.1.18060.1.1.1.3.5";
    public static final String SUBALIAS_OID = "1.2.6.1.4.1.18060.1.1.1.3.6";
    public static final String ALIAS_OID = "1.2.6.1.4.1.18060.1.1.1.3.7";
    private Database db = null;
    private SearchEngine engine = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AbstractContextPartition(Database db, SearchEngine searchEngine, AttributeType[] indexAttributes) throws NamingException {
        this.db = db;
        this.engine = searchEngine;
        HashSet<String> sysOidSet = new HashSet<String>();
        sysOidSet.add(EXISTANCE_OID);
        sysOidSet.add(HIERARCHY_OID);
        sysOidSet.add(UPDN_OID);
        sysOidSet.add(NDN_OID);
        sysOidSet.add(ONEALIAS_OID);
        sysOidSet.add(SUBALIAS_OID);
        sysOidSet.add(ALIAS_OID);
        int ii = 0;
        while (ii < indexAttributes.length) {
            String oid = indexAttributes[ii].getOid();
            if (sysOidSet.contains(oid)) {
                if (oid.equals(EXISTANCE_OID)) {
                    db.setExistanceIndexOn(indexAttributes[ii]);
                } else if (oid.equals(HIERARCHY_OID)) {
                    db.setHierarchyIndexOn(indexAttributes[ii]);
                } else if (oid.equals(UPDN_OID)) {
                    db.setUpdnIndexOn(indexAttributes[ii]);
                } else if (oid.equals(NDN_OID)) {
                    db.setNdnIndexOn(indexAttributes[ii]);
                } else if (oid.equals(ONEALIAS_OID)) {
                    db.setOneAliasIndexOn(indexAttributes[ii]);
                } else if (oid.equals(SUBALIAS_OID)) {
                    db.setSubAliasIndexOn(indexAttributes[ii]);
                } else {
                    if (!oid.equals(ALIAS_OID)) throw new NamingException("Unidentified system index " + oid);
                    db.setAliasIndexOn(indexAttributes[ii]);
                }
            } else {
                db.addIndexOn(indexAttributes[ii]);
            }
            ++ii;
        }
    }

    public Database getDb() {
        return this.db;
    }

    public SearchEngine getEngine() {
        return this.engine;
    }

    public void delete(Name dn) throws NamingException {
        BigInteger id = this.db.getEntryId(dn.toString());
        if (id == null) {
            throw new LdapNameNotFoundException("Could not find entry at '" + dn + "' to delete it!");
        }
        if (this.db.getChildCount(id) > 0) {
            LdapContextNotEmptyException cnee = new LdapContextNotEmptyException("[66] Cannot delete entry " + dn + " it has children!");
            cnee.setRemainingName(dn);
            throw cnee;
        }
        this.db.delete(id);
    }

    public void add(String updn, Name dn, Attributes entry) throws NamingException {
        this.db.add(updn, dn, entry);
    }

    public void modify(Name dn, int modOp, Attributes mods) throws NamingException {
        this.db.modify(dn, modOp, mods);
    }

    public void modify(Name dn, ModificationItem[] mods) throws NamingException {
        this.db.modify(dn, mods);
    }

    public NamingEnumeration list(Name base) throws NamingException {
        SearchResultEnumeration list = new SearchResultEnumeration(ArrayUtils.EMPTY_STRING_ARRAY, this.db.list(this.db.getEntryId(base.toString())), this.db);
        return list;
    }

    public NamingEnumeration search(Name base, Map env, ExprNode filter, SearchControls searchCtls) throws NamingException {
        String[] attrIds = searchCtls.getReturningAttributes();
        NamingEnumeration underlying = null;
        underlying = this.engine.search(base, env, filter, searchCtls);
        return new SearchResultEnumeration(attrIds, underlying, this.db);
    }

    public Attributes lookup(Name dn) throws NamingException {
        return this.db.lookup(this.db.getEntryId(dn.toString()));
    }

    public Attributes lookup(Name dn, String[] attrIds) throws NamingException {
        if (attrIds == null || attrIds.length == 0) {
            return this.lookup(dn);
        }
        Attributes entry = this.lookup(dn);
        LockableAttributesImpl retval = new LockableAttributesImpl();
        int ii = 0;
        while (ii < attrIds.length) {
            Attribute attr = entry.get(attrIds[0]);
            if (attr != null) {
                retval.put(attr);
            }
            ++ii;
        }
        return retval;
    }

    public boolean hasEntry(Name dn) throws NamingException {
        return this.db.getEntryId(dn.toString()) != null;
    }

    public void modifyRn(Name dn, String newRdn, boolean deleteOldRdn) throws NamingException {
        this.db.modifyRdn(dn, newRdn, deleteOldRdn);
    }

    public void move(Name oldChildDn, Name newParentDn) throws NamingException {
        this.db.move(oldChildDn, newParentDn);
    }

    public void move(Name oldChildDn, Name newParentDn, String newRdn, boolean deleteOldRdn) throws NamingException {
        this.db.move(oldChildDn, newParentDn, newRdn, deleteOldRdn);
    }

    public void sync() throws NamingException {
        this.db.sync();
    }

    public void close() throws NamingException {
        this.db.close();
    }

    public boolean isClosed() {
        return this.db.isClosed();
    }

    public void inspect() throws Exception {
        PartitionViewer viewer = new PartitionViewer(this.db, this.engine);
        viewer.execute();
    }
}

