/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.schema;

import org.apache.ldap.common.schema.Normalizer;
import org.apache.oro.text.perl.Perl5Util;

public class RegexNormalizer
implements Normalizer {
    private final Perl5Util perl = new Perl5Util();
    private String[] regexes;

    public RegexNormalizer(String[] regexes) {
        this.regexes = regexes;
    }

    public Object normalize(Object value) {
        if (value instanceof String) {
            String str = (String)value;
            for (int ii = 0; ii < this.regexes.length; ++ii) {
                str = this.perl.substitute(this.regexes[ii], str);
            }
            return str;
        }
        return value;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("RegexNormalizer( ");
        for (int ii = 0; ii < this.regexes.length; ++ii) {
            buf.append(this.regexes[ii]);
            if (ii >= this.regexes.length - 1) continue;
            buf.append(", ");
        }
        buf.append(" )");
        return buf.toString();
    }
}

