/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.schema;

import java.util.Comparator;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.apache.ldap.common.name.DnParser;
import org.apache.ldap.common.name.NameComponentNormalizer;

public class DnComparator
implements Comparator {
    private NameParser parser;

    public DnComparator() throws NamingException {
        this.parser = new DnParser();
    }

    public DnComparator(NameComponentNormalizer normalizer) throws NamingException {
        this.parser = new DnParser(normalizer);
    }

    public int compare(Object obj1, Object obj2) {
        Name dn1 = null;
        Name dn2 = null;
        if (obj1 instanceof Name) {
            dn1 = (Name)obj1;
        } else if (obj1 instanceof String) {
            try {
                dn1 = this.parser.parse((String)obj1);
            }
            catch (NamingException ne) {
                throw new IllegalArgumentException("first argument was not a distinguished name");
            }
        } else {
            throw new IllegalArgumentException("first argument was not a distinguished name");
        }
        if (obj2 instanceof Name) {
            dn2 = (Name)obj2;
        } else if (obj2 instanceof String) {
            try {
                dn2 = this.parser.parse((String)obj2);
            }
            catch (NamingException ne) {
                throw new IllegalArgumentException("second argument was not a distinguished name");
            }
        } else {
            throw new IllegalArgumentException("second argument was not a distinguished name");
        }
        return dn1.compareTo(dn2);
    }
}

