/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.message;

import org.apache.ldap.common.message.AbstractRequest;
import org.apache.ldap.common.message.MessageTypeEnum;
import org.apache.ldap.common.message.ModifyDnRequest;

public class ModifyDnRequestImpl
extends AbstractRequest
implements ModifyDnRequest {
    private String m_name;
    private String m_newRdn;
    private String m_newSuperior;
    private boolean m_deleteOldRdn = false;

    public ModifyDnRequestImpl(int id) {
        super(id, TYPE, true);
    }

    public boolean getDeleteOldRdn() {
        return this.m_deleteOldRdn;
    }

    public void setDeleteOldRdn(boolean deleteOldRdn) {
        this.lockCheck("Attempt to toggle deleteOldRdn flag of locked ModifyDnRequest!");
        this.m_deleteOldRdn = deleteOldRdn;
    }

    public boolean isMove() {
        return this.m_newSuperior != null;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.lockCheck("Attempt to alter entry name on locked ModifyDnRequest!");
        this.m_name = name;
    }

    public String getNewRdn() {
        return this.m_newRdn;
    }

    public void setNewRdn(String newRdn) {
        this.lockCheck("Atttempt to alter the newRdn of locked ModifyDnRequest!");
        this.m_newRdn = newRdn;
    }

    public String getNewSuperior() {
        return this.m_newSuperior;
    }

    public void setNewSuperior(String newSuperior) {
        this.m_newSuperior = newSuperior;
    }

    public MessageTypeEnum getResponseType() {
        return RESP_TYPE;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ModifyDnRequest req = (ModifyDnRequest)obj;
        if (this.m_name != null && req.getName() == null) {
            return false;
        }
        if (this.m_name == null && req.getName() != null) {
            return false;
        }
        if (this.m_name != null && req.getName() != null && !this.m_name.equals(req.getName())) {
            return false;
        }
        if (this.m_deleteOldRdn != req.getDeleteOldRdn()) {
            return false;
        }
        if (this.m_newRdn != null && req.getNewRdn() == null) {
            return false;
        }
        if (this.m_newRdn == null && req.getNewRdn() != null) {
            return false;
        }
        if (this.m_newRdn != null && req.getNewRdn() != null && !this.m_newRdn.equals(req.getNewRdn())) {
            return false;
        }
        if (this.m_newSuperior != null && req.getNewSuperior() == null) {
            return false;
        }
        if (this.m_newSuperior == null && req.getNewSuperior() != null) {
            return false;
        }
        return this.m_newSuperior == null || req.getNewSuperior() == null || this.m_newSuperior.equals(req.getNewSuperior());
    }
}

