/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.ldif;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import org.apache.ldap.common.ldif.LdifIteratorMonitor;
import org.apache.ldap.common.ldif.LdifIteratorMonitorAdapter;

public class LdifIterator
implements Iterator {
    private static final boolean DEBUG = false;
    private String prefetched = null;
    private LdifIteratorMonitor monitor = new LdifIteratorMonitorAdapter();
    private BufferedReader in = null;
    private StringBuffer buf = new StringBuffer();

    public LdifIterator(InputStream in) throws IOException {
        this(new InputStreamReader(in));
        if (in == null) {
            throw new NullPointerException("InputStream cannot be null!");
        }
    }

    public LdifIterator(Reader in) throws IOException {
        if (in == null) {
            throw new NullPointerException("Reader cannot be null!");
        }
        this.in = new BufferedReader(in);
        this.debug("<init>: -- opended file");
        this.prefetch();
        this.debug("<init>: -- prefetch complete");
    }

    public LdifIterator(InputStream in, LdifIteratorMonitor monitor) throws IOException {
        this(new InputStreamReader(in), monitor);
        if (in == null) {
            throw new NullPointerException("InputStream cannot be null!");
        }
    }

    public LdifIterator(Reader in, LdifIteratorMonitor monitor) throws IOException {
        this(in);
        if (monitor != null) {
            this.monitor = monitor;
        }
        if (in == null) {
            throw new NullPointerException("Reader cannot be null!");
        }
    }

    public boolean hasNext() {
        return null != this.prefetched;
    }

    public Object next() {
        String retVal = this.prefetched;
        try {
            this.debug("next(): -- called");
            this.prefetch();
        }
        catch (IOException e) {
            this.error("Premature termination of LDIF iterator due to underlying stream error", e);
        }
        return retVal;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void error(String msg, Throwable throwable) {
        this.monitor.fatalFailure(msg, throwable);
    }

    private void debug(String msg) {
        this.monitor.infoAvailable(msg);
    }

    private void prefetch() throws IOException {
        boolean insideLdif = false;
        String line = null;
        while (null != (line = this.in.readLine())) {
            this.debug("readLine(): " + line);
            line = LdifIterator.filterComment(line).trim();
            if (insideLdif) {
                if (line.equals("")) break;
                this.debug("prefetch(): -- appending last line to buffer");
                this.buf.append(line).append('\n');
                continue;
            }
            if (line.equals("")) continue;
            insideLdif = true;
            this.debug("prefetch(): -- appending last line to buffer");
            this.buf.append(line).append('\n');
        }
        if (null == line && 0 == this.buf.length()) {
            this.debug("prefetch(): -- line was null and buffer was empty");
            this.debug("prefetch(): -- iterator has been consumed");
            this.prefetched = null;
        } else {
            this.debug("prefetch(): -- LDIF prefetched and set as next");
            this.prefetched = this.buf.toString();
        }
        this.buf.setLength(0);
        this.debug("prefetch(): -- LDIF buffer cleared");
    }

    public static String filterComment(String line) {
        int index = line.indexOf(35);
        if (-1 == index) {
            return line;
        }
        if (index == 0) {
            return "";
        }
        while (-1 != index) {
            if (index - 1 > 0 && '\\' == line.charAt(index - 1)) {
                if (index + 1 < line.length()) {
                    index = line.indexOf(35, index + 1);
                    continue;
                }
                return line;
            }
            return line.substring(0, index);
        }
        return line;
    }
}

