/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.filter;

import java.util.ArrayList;
import javax.naming.NamingException;
import org.apache.ldap.common.filter.FilterVisitor;
import org.apache.ldap.common.filter.LeafNode;
import org.apache.ldap.common.schema.Normalizer;
import org.apache.ldap.common.util.StringTools;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class SubstringNode
extends LeafNode {
    private final String m_initial;
    private final String m_final;
    private final ArrayList m_any;
    private transient RE m_regex = null;

    public SubstringNode(String a_attribute, String a_initial, String a_final) {
        super(a_attribute, 2);
        this.m_any = new ArrayList(2);
        this.m_final = a_final;
        this.m_initial = a_initial;
    }

    public SubstringNode(ArrayList a_anyList, String a_attribute, String a_initial, String a_final) {
        super(a_attribute, 2);
        this.m_any = a_anyList;
        this.m_final = a_final;
        this.m_initial = a_initial;
    }

    public final String getInitial() {
        return this.m_initial;
    }

    public final String getFinal() {
        return this.m_final;
    }

    public final ArrayList getAny() {
        return this.m_any;
    }

    public final RE getRegex(Normalizer normalizer) throws RESyntaxException, NamingException {
        if (this.m_regex != null) {
            return this.m_regex;
        }
        if (this.m_any.size() > 0) {
            String[] l_any = new String[this.m_any.size()];
            for (int ii = 0; ii < l_any.length; ++ii) {
                l_any[ii] = (String)normalizer.normalize(this.m_any.get(ii));
            }
            String initialStr = null;
            if (this.m_initial != null) {
                initialStr = (String)normalizer.normalize(this.m_initial);
            }
            String finalStr = null;
            if (this.m_final != null) {
                finalStr = (String)normalizer.normalize(this.m_final);
            }
            return StringTools.getRegex(initialStr, l_any, finalStr);
        }
        String initialStr = null;
        if (this.m_initial != null) {
            initialStr = (String)normalizer.normalize(this.m_initial);
        }
        String finalStr = null;
        if (this.m_final != null) {
            finalStr = (String)normalizer.normalize(this.m_final);
        }
        return StringTools.getRegex(initialStr, null, finalStr);
    }

    public String toString() {
        StringBuffer l_buf = new StringBuffer();
        this.printToBuffer(l_buf);
        return l_buf.toString();
    }

    public void printToBuffer(StringBuffer a_buf) {
        a_buf.append('(').append(this.getAttribute()).append('=');
        if (null != this.m_initial) {
            a_buf.append(this.m_initial).append('*');
        } else {
            a_buf.append('*');
        }
        for (int ii = 0; ii < this.m_any.size(); ++ii) {
            a_buf.append((String)this.m_any.get(ii));
            a_buf.append('*');
        }
        if (null != this.m_final) {
            a_buf.append(this.m_final);
        }
        a_buf.append(')');
        if (null != this.getAnnotations() && this.getAnnotations().containsKey("count")) {
            a_buf.append('[');
            a_buf.append(this.getAnnotations().get("count").toString());
            a_buf.append("] ");
        } else {
            a_buf.append(' ');
        }
    }

    public void accept(FilterVisitor a_visitor) {
        if (a_visitor.canVisit(this)) {
            a_visitor.visit(this);
        }
    }
}

