/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.filter;

import org.apache.ldap.common.filter.FilterVisitor;
import org.apache.ldap.common.filter.LeafNode;

public class SimpleNode
extends LeafNode {
    private final String m_value;

    public SimpleNode(String a_attribute, String a_value, int a_type) {
        super(a_attribute, a_type);
        this.m_value = a_value;
        switch (a_type) {
            case 5: {
                break;
            }
            case 0: {
                break;
            }
            case 6: {
                throw new IllegalArgumentException("Assertion type supplied is extensible.  Use ExtensibleNode instead.");
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                throw new IllegalArgumentException("Assertion type supplied is presence.  Use PresenceNode instead.");
            }
            case 2: {
                throw new IllegalArgumentException("Assertion type supplied is substring.  Use SubstringNode instead.");
            }
            default: {
                throw new IllegalArgumentException("Attribute value assertion type is undefined.");
            }
        }
    }

    public final String getValue() {
        return this.m_value;
    }

    public void printToBuffer(StringBuffer a_buf) {
        a_buf.append('(').append(this.getAttribute());
        switch (this.getAssertionType()) {
            case 5: {
                a_buf.append("~=");
                break;
            }
            case 0: {
                a_buf.append("=");
                break;
            }
            case 3: {
                a_buf.append(">=");
                break;
            }
            case 4: {
                a_buf.append("<=");
                break;
            }
            default: {
                a_buf.append("UNKNOWN");
            }
        }
        a_buf.append(this.m_value);
        a_buf.append(')');
        if (null != this.getAnnotations() && this.getAnnotations().containsKey("count")) {
            a_buf.append('[');
            a_buf.append(this.getAnnotations().get("count").toString());
            a_buf.append("] ");
        } else {
            a_buf.append(' ');
        }
    }

    public String toString() {
        StringBuffer l_buf = new StringBuffer();
        this.printToBuffer(l_buf);
        return l_buf.toString();
    }

    public void accept(FilterVisitor a_visitor) {
        if (a_visitor.canVisit(this)) {
            a_visitor.visit(this);
        }
    }
}

