/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.filter;

import org.apache.ldap.common.filter.FilterVisitor;
import org.apache.ldap.common.filter.LeafNode;

public class ExtensibleNode
extends LeafNode {
    private final String value;
    private final String m_matchingRuleId;
    private boolean m_dnAttributes = false;

    public ExtensibleNode(String a_attribute, String a_value, String a_matchingRuleId, boolean a_dnAttributes) {
        super(a_attribute, 6);
        this.value = a_value;
        this.m_matchingRuleId = a_matchingRuleId;
        this.m_dnAttributes = a_dnAttributes;
    }

    public boolean dnAttributes() {
        return this.m_dnAttributes;
    }

    public String getMatchingRuleId() {
        return this.m_matchingRuleId;
    }

    public final String getValue() {
        return this.value;
    }

    public void printToBuffer(StringBuffer a_buf) {
        a_buf.append('(').append(this.getAttribute());
        a_buf.append("-");
        a_buf.append(this.m_dnAttributes);
        a_buf.append("-EXTENSIBLE-");
        a_buf.append(this.m_matchingRuleId);
        a_buf.append("-");
        a_buf.append(this.value);
        a_buf.append(')');
        if (null != this.getAnnotations() && this.getAnnotations().containsKey("count")) {
            a_buf.append('[');
            a_buf.append(this.getAnnotations().get("count").toString());
            a_buf.append("] ");
        } else {
            a_buf.append(' ');
        }
    }

    public String toString() {
        StringBuffer l_buf = new StringBuffer();
        this.printToBuffer(l_buf);
        return l_buf.toString();
    }

    public void accept(FilterVisitor a_visitor) {
        if (a_visitor.canVisit(this)) {
            a_visitor.visit(this);
        }
    }
}

