/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1.encoder.extended;

import org.apache.asn1.ber.DefaultMutableTupleNode;
import org.apache.asn1.ber.MutableTupleNode;
import org.apache.asn1.ber.TagEnum;
import org.apache.asn1.ber.Tuple;
import org.apache.asn1.ber.TupleNode;
import org.apache.asn1.ber.primitives.UniversalTag;
import org.apache.ldap.common.berlib.asn1.LdapTag;
import org.apache.ldap.common.berlib.asn1.encoder.EncoderUtils;
import org.apache.ldap.common.message.ExtendedRequest;

public class ExtendedRequestEncoder {
    public static final ExtendedRequestEncoder INSTANCE = new ExtendedRequestEncoder();

    public TupleNode encode(ExtendedRequest request) {
        DefaultMutableTupleNode top = new DefaultMutableTupleNode(new Tuple());
        top.getTuple().setTag((TagEnum)UniversalTag.SEQUENCE_SEQUENCE_OF, false);
        top.getTuple().setLength(-2);
        DefaultMutableTupleNode child = (DefaultMutableTupleNode)EncoderUtils.encode(request.getMessageId());
        top.addLast(child);
        child.setParent((MutableTupleNode)top);
        DefaultMutableTupleNode extendedReq = new DefaultMutableTupleNode(new Tuple());
        extendedReq.getTuple().setTag((TagEnum)LdapTag.EXTENDED_REQUEST, false);
        extendedReq.getTuple().setLength(-2);
        child = (DefaultMutableTupleNode)EncoderUtils.encode((TagEnum)LdapTag.CONTEXT_SPECIFIC_TAG_0, request.getOid());
        extendedReq.addLast(child);
        child.setParent((MutableTupleNode)extendedReq);
        if (request.getPayload() != null) {
            child = (DefaultMutableTupleNode)EncoderUtils.encode((TagEnum)LdapTag.CONTEXT_SPECIFIC_TAG_1, request.getPayload());
            extendedReq.addLast(child);
            child.setParent((MutableTupleNode)extendedReq);
        }
        top.addLast(extendedReq);
        extendedReq.setParent((MutableTupleNode)top);
        return top;
    }
}

