/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1.decoder.search;

import java.nio.ByteBuffer;
import org.apache.asn1.ber.TypeClass;
import org.apache.asn1.ber.primitives.PrimitiveUtils;
import org.apache.asn1.ber.primitives.UniversalTag;
import org.apache.ldap.common.berlib.asn1.decoder.search.BaseSearchRequestRule;
import org.apache.ldap.common.message.ScopeEnum;

public class ScopeRule
extends BaseSearchRequestRule {
    private final byte[] value = new byte[4];
    private int pos;
    private int length;

    public ScopeRule() {
        super(3);
    }

    public void tag(int id, boolean isPrimitive, TypeClass typeClass) {
        super.tag(id, isPrimitive, typeClass);
        if (this.getDigester().getTopTag() != UniversalTag.ENUMERATED.getPrimitiveTag()) {
            this.setEnabled(false);
        }
        if (this.getProcessing().getState() != this.getProcessing().SCOPE_STATE) {
            this.setEnabled(false);
        }
    }

    public void length(int length) {
        if (!this.isEnabled()) {
            return;
        }
        if (length > 4 || length < 0) {
            throw new IllegalArgumentException("The target primitive for this rule can only hold integers of 32 bits or 4 bytes.  The length of the field however is " + length);
        }
        this.length = length;
    }

    public void value(ByteBuffer buf) {
        if (!this.isEnabled()) {
            return;
        }
        if (buf == null) {
            return;
        }
        while (buf.hasRemaining() && this.pos + 1 <= this.length) {
            this.value[this.pos] = buf.get();
            ++this.pos;
        }
    }

    public void finish() {
        if (!this.isEnabled()) {
            this.pos = 0;
            this.length = 0;
            super.finish();
            return;
        }
        int numba = PrimitiveUtils.decodeInt((byte[])this.value, (int)0, (int)this.length);
        switch (numba) {
            case 0: {
                this.getRequest().setScope(ScopeEnum.BASEOBJECT);
                break;
            }
            case 1: {
                this.getRequest().setScope(ScopeEnum.SINGLELEVEL);
                break;
            }
            case 2: {
                this.getRequest().setScope(ScopeEnum.WHOLESUBTREE);
                break;
            }
            default: {
                throw new IllegalStateException("expected 0, 1, or 2 for scope but got " + numba);
            }
        }
        this.pos = 0;
        this.length = 0;
        super.finish();
    }
}

