/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1.decoder.bind;

import java.nio.ByteBuffer;
import org.apache.asn1.ber.TagEnum;
import org.apache.asn1.ber.digester.rules.PrimitiveOctetStringRule;
import org.apache.ldap.common.message.BindRequest;

public class BindSimpleCredentialsRule
extends PrimitiveOctetStringRule {
    private static final TagEnum TAG = new TagEnum("BindSimpleCredentials", Integer.MIN_VALUE, 0){};

    public BindSimpleCredentialsRule() {
        super(TAG);
    }

    public void finish() {
        super.finish();
        ByteBuffer buf = (ByteBuffer)this.getDigester().pop();
        BindRequest req = (BindRequest)this.getDigester().peek();
        byte[] credentials = null;
        if (buf.limit() == buf.capacity() && buf.hasArray()) {
            credentials = buf.array();
        } else {
            credentials = new byte[buf.remaining()];
            buf.get(credentials);
        }
        req.setSimple(true);
        req.setCredentials(credentials);
    }
}

