/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.protocol;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.spi.InitialContextFactory;
import org.apache.ldap.common.exception.LdapNoPermissionException;
import org.apache.mina.protocol.ProtocolSession;

public class SessionRegistry {
    private static SessionRegistry s_singleton;
    private final Map contexts = new HashMap();
    private Hashtable env;

    public static SessionRegistry getSingleton() {
        return s_singleton;
    }

    static void releaseSingleton() {
        s_singleton = null;
    }

    SessionRegistry(Hashtable env) {
        if (s_singleton != null) {
            throw new IllegalStateException("there can only be one singlton");
        }
        s_singleton = this;
        if (env == null) {
            this.env = new Hashtable();
            this.env.put("java.naming.provider.url", "");
            this.env.put("java.naming.factory.initial", "org.apache.ldap.server.jndi.ServerContextFactory");
        } else {
            this.env = env;
            this.env.put("java.naming.provider.url", "");
        }
    }

    public Hashtable getEnvironment() {
        return (Hashtable)this.env.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LdapContext getLdapContext(ProtocolSession session, Control[] connCtls, boolean allowAnonymous) throws NamingException {
        LdapContext ctx = null;
        Map map = this.contexts;
        synchronized (map) {
            ctx = (LdapContext)this.contexts.get(session);
        }
        if (ctx == null && allowAnonymous) {
            if (this.env.containsKey("server.disable.anonymous")) {
                throw new LdapNoPermissionException("Anonymous binds have been disabled!");
            }
            Hashtable cloned = (Hashtable)this.env.clone();
            if (this.env.containsKey("server.use.factory.instance")) {
                InitialContextFactory factory = (InitialContextFactory)this.env.get("server.use.factory.instance");
                if (factory == null) {
                    throw new NullPointerException("server.use.factory.instance was set in env but was null");
                }
                ctx = (LdapContext)factory.getInitialContext(this.env);
            } else {
                ctx = new InitialLdapContext(cloned, connCtls);
            }
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLdapContext(ProtocolSession session, LdapContext ictx) {
        Map map = this.contexts;
        synchronized (map) {
            this.contexts.put(session, ictx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ProtocolSession session) {
        Map map = this.contexts;
        synchronized (map) {
            this.contexts.remove(session);
        }
    }

    public void terminateSession(ProtocolSession session) {
        session.close();
    }
}

