/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.protocol;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.ldap.common.Lockable;
import org.apache.ldap.common.exception.LdapException;
import org.apache.ldap.common.message.LdapResult;
import org.apache.ldap.common.message.LdapResultImpl;
import org.apache.ldap.common.message.MessageTypeEnum;
import org.apache.ldap.common.message.Referral;
import org.apache.ldap.common.message.ReferralImpl;
import org.apache.ldap.common.message.ResultCodeEnum;
import org.apache.ldap.common.message.SearchRequest;
import org.apache.ldap.common.message.SearchResponseDone;
import org.apache.ldap.common.message.SearchResponseDoneImpl;
import org.apache.ldap.common.message.SearchResponseEntryImpl;
import org.apache.ldap.common.message.SearchResponseReferenceImpl;
import org.apache.ldap.common.util.ArrayUtils;
import org.apache.ldap.common.util.ExceptionUtils;
import org.apache.ldap.server.protocol.SessionRegistry;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.protocol.handler.MessageHandler;

public class SearchHandler
implements MessageHandler {
    private static final String DEREFALIASES_KEY = "java.naming.ldap.derefAliases";

    public void messageReceived(ProtocolSession session, Object request) {
        SearchRequest req = (SearchRequest)request;
        NamingEnumeration<SearchResult> list = null;
        String[] ids = null;
        HashSet<String> retAttrs = new HashSet<String>();
        retAttrs.addAll(req.getAttributes());
        if (retAttrs.size() > 0 && !retAttrs.contains("ref")) {
            retAttrs.add("ref");
            ids = retAttrs.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        } else if (retAttrs.size() > 0) {
            ids = retAttrs.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        }
        SearchControls controls = new SearchControls();
        controls.setCountLimit(req.getSizeLimit());
        controls.setTimeLimit(req.getTimeLimit());
        controls.setSearchScope(req.getScope().getValue());
        controls.setReturningObjFlag(req.getTypesOnly());
        controls.setReturningAttributes(ids);
        controls.setDerefLinkFlag(true);
        try {
            LdapContext ctx = SessionRegistry.getSingleton().getLdapContext(session, null, true);
            ctx.addToEnvironment(DEREFALIASES_KEY, req.getDerefAliases().getName());
            ctx.addToEnvironment("__filter__", req.getFilter());
            list = ctx.search(req.getBase(), null, controls);
            ctx.removeFromEnvironment("__filter__");
            if (list.hasMore()) {
                SearchResponseIterator it = new SearchResponseIterator(req, list);
                while (it.hasNext()) {
                    session.write(it.next());
                }
                return;
            }
            list.close();
            SearchResponseDoneImpl resp = new SearchResponseDoneImpl(req.getMessageId());
            resp.setLdapResult((LdapResult)new LdapResultImpl((Lockable)resp));
            resp.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
            resp.getLdapResult().setMatchedDn(req.getBase());
            Iterator<SearchResponseDoneImpl> it = Collections.singleton(resp).iterator();
            while (it.hasNext()) {
                session.write((Object)it.next());
            }
            return;
        }
        catch (NamingException e) {
            String msg = "failed on search operation:\n" + req + "\n";
            msg = msg + ExceptionUtils.getStackTrace((Throwable)e);
            SearchResponseDoneImpl resp = new SearchResponseDoneImpl(req.getMessageId());
            ResultCodeEnum rc = null;
            rc = e instanceof LdapException ? ((LdapException)e).getResultCode() : ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)req.getType());
            resp.setLdapResult((LdapResult)new LdapResultImpl((Lockable)resp));
            resp.getLdapResult().setResultCode(rc);
            resp.getLdapResult().setErrorMessage(msg);
            if (e.getResolvedName() != null) {
                resp.getLdapResult().setMatchedDn(e.getResolvedName().toString());
            } else {
                resp.getLdapResult().setMatchedDn("");
            }
            Iterator<SearchResponseDoneImpl> it = Collections.singleton(resp).iterator();
            while (it.hasNext()) {
                session.write((Object)it.next());
            }
            return;
        }
    }

    SearchResponseDone getResponse(SearchRequest req, NamingException e) {
        String msg = "failed on search operation:\n" + req + "\n";
        msg = msg + ExceptionUtils.getStackTrace((Throwable)e);
        SearchResponseDoneImpl resp = new SearchResponseDoneImpl(req.getMessageId());
        ResultCodeEnum rc = null;
        rc = e instanceof LdapException ? ((LdapException)e).getResultCode() : ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)req.getType());
        resp.setLdapResult((LdapResult)new LdapResultImpl((Lockable)resp));
        resp.getLdapResult().setResultCode(rc);
        resp.getLdapResult().setErrorMessage(msg);
        if (e.getResolvedName() != null) {
            resp.getLdapResult().setMatchedDn(e.getResolvedName().toString());
        } else {
            resp.getLdapResult().setMatchedDn("");
        }
        return resp;
    }

    class SearchResponseIterator
    implements Iterator {
        private final SearchRequest req;
        private final NamingEnumeration underlying;
        private SearchResponseDone respDone;
        private boolean done;
        private Object prefetched;

        public SearchResponseIterator(SearchRequest req, NamingEnumeration underlying) {
            block10: {
                this.done = false;
                this.req = req;
                this.underlying = underlying;
                try {
                    if (!underlying.hasMore()) break block10;
                    SearchResult result = (SearchResult)underlying.next();
                    Attribute ref = result.getAttributes().get("ref");
                    if (ref == null || ref.size() > 0) {
                        SearchResponseEntryImpl respEntry = new SearchResponseEntryImpl(req.getMessageId());
                        respEntry.setAttributes(result.getAttributes());
                        respEntry.setObjectName(result.getName());
                        this.prefetched = respEntry;
                        break block10;
                    }
                    SearchResponseReferenceImpl respRef = new SearchResponseReferenceImpl(req.getMessageId());
                    respRef.setReferral((Referral)new ReferralImpl((Lockable)respRef));
                    for (int ii = 0; ii < ref.size(); ++ii) {
                        try {
                            String url = (String)ref.get(ii);
                            respRef.getReferral().addLdapUrl(url);
                            continue;
                        }
                        catch (NamingException e) {
                            try {
                                underlying.close();
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                            this.prefetched = null;
                            this.respDone = SearchHandler.this.getResponse(req, e);
                        }
                    }
                    this.prefetched = respRef;
                }
                catch (NamingException e) {
                    try {
                        this.underlying.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    this.respDone = SearchHandler.this.getResponse(req, e);
                }
            }
        }

        public boolean hasNext() {
            return !this.done;
        }

        public Object next() {
            Object next = this.prefetched;
            SearchResult result = null;
            if (this.done) {
                throw new NoSuchElementException();
            }
            if (this.respDone != null) {
                this.done = true;
                return this.respDone;
            }
            try {
                if (!this.underlying.hasMore()) {
                    try {
                        this.underlying.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    this.respDone = new SearchResponseDoneImpl(this.req.getMessageId());
                    this.respDone.setLdapResult((LdapResult)new LdapResultImpl((Lockable)this.respDone));
                    this.respDone.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
                    this.respDone.getLdapResult().setMatchedDn(this.req.getBase());
                    this.prefetched = null;
                    return next;
                }
                result = (SearchResult)this.underlying.next();
            }
            catch (NamingException e) {
                try {
                    this.underlying.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                this.prefetched = null;
                this.respDone = SearchHandler.this.getResponse(this.req, e);
                return next;
            }
            Attribute ref = result.getAttributes().get("ref");
            if (ref == null || ref.size() > 0) {
                SearchResponseEntryImpl respEntry = new SearchResponseEntryImpl(this.req.getMessageId());
                respEntry.setAttributes(result.getAttributes());
                respEntry.setObjectName(result.getName());
                this.prefetched = respEntry;
            } else {
                SearchResponseReferenceImpl respRef = new SearchResponseReferenceImpl(this.req.getMessageId());
                respRef.setReferral((Referral)new ReferralImpl((Lockable)respRef));
                for (int ii = 0; ii < ref.size(); ++ii) {
                    try {
                        String url = (String)ref.get(ii);
                        respRef.getReferral().addLdapUrl(url);
                        continue;
                    }
                    catch (NamingException e) {
                        try {
                            this.underlying.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        this.prefetched = null;
                        this.respDone = SearchHandler.this.getResponse(this.req, e);
                        return next;
                    }
                }
                this.prefetched = respRef;
            }
            return next;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

