/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.protocol;

import java.io.IOException;
import org.apache.kerberos.io.encoder.ErrorMessageEncoder;
import org.apache.kerberos.io.encoder.KdcReplyEncoder;
import org.apache.kerberos.messages.ErrorMessage;
import org.apache.kerberos.messages.KdcReply;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.protocol.ProtocolEncoder;
import org.apache.mina.protocol.ProtocolEncoderOutput;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.protocol.ProtocolViolationException;

public class KerberosEncoder
implements ProtocolEncoder {
    private KdcReplyEncoder replyEncoder = new KdcReplyEncoder();
    private ErrorMessageEncoder errorEncoder = new ErrorMessageEncoder();

    public void encode(ProtocolSession session, Object message, ProtocolEncoderOutput out) throws ProtocolViolationException {
        ByteBuffer buf = ByteBuffer.allocate((int)1024);
        try {
            if (message instanceof KdcReply) {
                this.replyEncoder.encode((KdcReply)message, buf.buf());
            } else if (message instanceof ErrorMessage) {
                this.errorEncoder.encode((ErrorMessage)message, buf.buf());
            }
            buf.flip();
            out.write(buf);
        }
        catch (IOException ioe) {
            throw new ProtocolViolationException();
        }
    }
}

