/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.util;

import java.io.Serializable;
import java.util.Arrays;

public class Queue
implements Serializable {
    private static final long serialVersionUID = 3835151744526464313L;
    private static final int DEFAULT_CAPACITY = 4;
    private static final int DEFAULT_MASK = 3;
    private Object[] items = new Object[4];
    private int mask = 3;
    private int first = 0;
    private int last = 0;
    private int size = 0;

    public int capacity() {
        return this.items.length;
    }

    public void clear() {
        Arrays.fill(this.items, null);
        this.first = 0;
        this.last = 0;
        this.size = 0;
    }

    public Object pop() {
        if (this.size == 0) {
            return null;
        }
        Object ret = this.items[this.first];
        this.items[this.first] = null;
        this.first = this.first + 1 & this.mask;
        --this.size;
        return ret;
    }

    public void push(Object obj) {
        if (this.size == this.items.length) {
            int oldLen = this.items.length;
            Object[] tmp = new Object[oldLen * 2];
            if (this.first < this.last) {
                System.arraycopy(this.items, this.first, tmp, 0, this.last - this.first);
            } else {
                System.arraycopy(this.items, this.first, tmp, 0, oldLen - this.first);
                System.arraycopy(this.items, 0, tmp, oldLen - this.first, this.last);
            }
            this.first = 0;
            this.last = oldLen;
            this.items = tmp;
            this.mask = tmp.length - 1;
        }
        this.items[this.last] = obj;
        this.last = this.last + 1 & this.mask;
        ++this.size;
    }

    public Object first() {
        if (this.size == 0) {
            return null;
        }
        return this.items[this.first];
    }

    public Object last() {
        if (this.size == 0) {
            return null;
        }
        return this.items[this.last + this.items.length - 1 & this.mask];
    }

    public Object get(int idx) {
        return this.items[this.first + idx & this.mask];
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        return "first=" + this.first + ", last=" + this.last + ", size=" + this.size + ", mask = " + this.mask;
    }
}

