/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.io.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.net.SocketTimeoutException;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.io.IoHandlerAdapter;
import org.apache.mina.io.IoSession;

public abstract class StreamIoHandler
extends IoHandlerAdapter {
    private static final String KEY_IN = "BlockingIoHandler.in";
    private static final String KEY_OUT = "BlockingIoHandler.out";
    private static final String KEY_STARTED = "BlockingIoHandler.started";
    private int readTimeout;
    private int writeTimeout;

    protected StreamIoHandler() {
    }

    protected abstract void processStreamIo(IoSession var1, InputStream var2, OutputStream var3);

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public void sessionOpened(IoSession session) {
        session.getConfig().setWriteTimeout(this.writeTimeout);
        session.getConfig().setIdleTime(IdleStatus.READER_IDLE, this.readTimeout);
        PipedOutputStream out = new PipedOutputStream();
        session.setAttribute(KEY_OUT, out);
        try {
            session.setAttribute(KEY_IN, new PipedInputStream(out));
        }
        catch (IOException e) {
            throw new StreamIoException(e);
        }
    }

    public void sessionClosed(IoSession session) {
        PipedOutputStream out = (PipedOutputStream)session.getAttribute(KEY_OUT);
        try {
            out.close();
        }
        catch (IOException e) {
            throw new StreamIoException(e);
        }
    }

    public void dataRead(IoSession session, ByteBuffer buf) {
        PipedInputStream in = (PipedInputStream)session.getAttribute(KEY_IN);
        PipedOutputStream out = (PipedOutputStream)session.getAttribute(KEY_OUT);
        java.nio.ByteBuffer nioBuf = buf.buf();
        int offset = nioBuf.position();
        int length = nioBuf.limit() - offset;
        if (!nioBuf.hasArray()) {
            ByteBuffer heapBuf = ByteBuffer.allocate(length, false);
            heapBuf.put(buf);
            heapBuf.flip();
            nioBuf = heapBuf.buf();
            offset = 0;
        }
        try {
            out.write(nioBuf.array(), offset, length);
        }
        catch (IOException e) {
            throw new StreamIoException(e);
        }
        finally {
            this.beginService(session, in);
        }
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        PipedInputStream in = (PipedInputStream)session.getAttribute(KEY_IN);
        IOException e = null;
        if (cause instanceof StreamIoException) {
            e = (IOException)cause.getCause();
        } else if (cause instanceof IOException) {
            e = (IOException)cause;
        }
        if (e != null && in != null) {
            in.setException(e);
            this.beginService(session, in);
        } else {
            cause.printStackTrace();
            session.close();
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        if (status == IdleStatus.READER_IDLE) {
            throw new StreamIoException(new SocketTimeoutException("Read timeout"));
        }
    }

    private void beginService(IoSession session, PipedInputStream in) {
        if (session.getAttribute(KEY_STARTED) == null) {
            session.setAttribute(KEY_STARTED, Boolean.TRUE);
            this.processStreamIo(session, in, new ServiceOutputStream(session));
        }
    }

    private static class StreamIoException
    extends RuntimeException {
        private static final long serialVersionUID = 3976736960742503222L;

        public StreamIoException(IOException cause) {
            super(cause);
        }
    }

    private static class ServiceOutputStream
    extends OutputStream {
        private final IoSession session;

        public ServiceOutputStream(IoSession session) {
            this.session = session;
        }

        public void close() {
            this.session.close(true);
        }

        public void flush() {
        }

        public void write(byte[] b, int off, int len) {
            ByteBuffer buf = ByteBuffer.wrap(b, off, len);
            buf.acquire();
            this.session.write(buf, null);
        }

        public void write(byte[] b) {
            ByteBuffer buf = ByteBuffer.wrap(b);
            buf.acquire();
            this.session.write(buf, null);
        }

        public void write(int b) {
            ByteBuffer buf = ByteBuffer.allocate(1);
            buf.put((byte)b);
            buf.flip();
            this.session.write(buf, null);
        }
    }

    private static class PipedInputStream
    extends java.io.PipedInputStream {
        private IOException exception;

        public PipedInputStream(PipedOutputStream src) throws IOException {
            super(src);
        }

        public void setException(IOException e) {
            this.exception = e;
        }

        public synchronized int read() throws IOException {
            this.throwException();
            return super.read();
        }

        public synchronized int read(byte[] b, int off, int len) throws IOException {
            this.throwException();
            return super.read(b, off, len);
        }

        private void throwException() throws IOException {
            if (this.exception != null) {
                throw this.exception;
            }
        }
    }
}

