/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.Session;
import org.apache.mina.common.SessionConfig;
import org.apache.mina.common.SessionInitializer;
import org.apache.mina.io.datagram.DatagramSessionConfig;
import org.apache.mina.io.socket.SocketSessionConfig;

public class DefaultSessionInitializer
implements SessionInitializer {
    private final Map attributes = new HashMap();

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Object setAttribute(String key, Object value) {
        return this.attributes.put(key, value);
    }

    public Object removeAttribute(String key) {
        return this.attributes.remove(key);
    }

    public Set getAttributeKeys() {
        return this.attributes.keySet();
    }

    public void initializeSession(Session session) throws IOException {
        SessionConfig config = session.getConfig();
        if (config instanceof SocketSessionConfig) {
            SocketSessionConfig ssc = (SocketSessionConfig)config;
            ssc.setReuseAddress(true);
            ssc.setKeepAlive(true);
        } else if (config instanceof DatagramSessionConfig) {
            DatagramSessionConfig dsc = (DatagramSessionConfig)config;
            dsc.setReuseAddress(true);
        }
        Iterator it = this.attributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            session.setAttribute((String)e.getKey(), e.getValue());
        }
    }
}

