/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.security.engine.core.dto;

import com.google.common.collect.ImmutableList;
import digital.nedra.commons.starter.security.engine.core.Fields;

public final class RoleAuthoritiesDto {
    private final String role;
    private final ImmutableList<RoleAuthorityDto> authorities;

    RoleAuthoritiesDto(String role, ImmutableList<RoleAuthorityDto> authorities) {
        this.role = role;
        this.authorities = authorities;
    }

    public static RoleAuthoritiesDtoBuilder builder() {
        return new RoleAuthoritiesDtoBuilder();
    }

    public String getRole() {
        return this.role;
    }

    public ImmutableList<RoleAuthorityDto> getAuthorities() {
        return this.authorities;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RoleAuthoritiesDto)) {
            return false;
        }
        RoleAuthoritiesDto other = (RoleAuthoritiesDto)o;
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        ImmutableList<RoleAuthorityDto> this$authorities = this.getAuthorities();
        ImmutableList<RoleAuthorityDto> other$authorities = other.getAuthorities();
        return !(this$authorities == null ? other$authorities != null : !this$authorities.equals(other$authorities));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        ImmutableList<RoleAuthorityDto> $authorities = this.getAuthorities();
        result = result * 59 + ($authorities == null ? 43 : $authorities.hashCode());
        return result;
    }

    public String toString() {
        return "RoleAuthoritiesDto(role=" + this.getRole() + ", authorities=" + this.getAuthorities() + ")";
    }

    public static class RoleAuthoritiesDtoBuilder {
        private String role;
        private ImmutableList<RoleAuthorityDto> authorities;

        RoleAuthoritiesDtoBuilder() {
        }

        public RoleAuthoritiesDtoBuilder role(String role) {
            this.role = role;
            return this;
        }

        public RoleAuthoritiesDtoBuilder authorities(ImmutableList<RoleAuthorityDto> authorities) {
            this.authorities = authorities;
            return this;
        }

        public RoleAuthoritiesDto build() {
            return new RoleAuthoritiesDto(this.role, this.authorities);
        }

        public String toString() {
            return "RoleAuthoritiesDto.RoleAuthoritiesDtoBuilder(role=" + this.role + ", authorities=" + this.authorities + ")";
        }
    }

    public static final class RoleAuthorityDto {
        private final String name;
        private final boolean available;
        private final ImmutableList<String> fields;
        private final Fields.Type type;

        RoleAuthorityDto(String name, boolean available, ImmutableList<String> fields, Fields.Type type) {
            this.name = name;
            this.available = available;
            this.fields = fields;
            this.type = type;
        }

        public static RoleAuthorityDtoBuilder builder() {
            return new RoleAuthorityDtoBuilder();
        }

        public String getName() {
            return this.name;
        }

        public boolean isAvailable() {
            return this.available;
        }

        public ImmutableList<String> getFields() {
            return this.fields;
        }

        public Fields.Type getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RoleAuthorityDto)) {
                return false;
            }
            RoleAuthorityDto other = (RoleAuthorityDto)o;
            if (this.isAvailable() != other.isAvailable()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            ImmutableList<String> this$fields = this.getFields();
            ImmutableList<String> other$fields = other.getFields();
            if (this$fields == null ? other$fields != null : !this$fields.equals(other$fields)) {
                return false;
            }
            Fields.Type this$type = this.getType();
            Fields.Type other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAvailable() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            ImmutableList<String> $fields = this.getFields();
            result = result * 59 + ($fields == null ? 43 : $fields.hashCode());
            Fields.Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        public String toString() {
            return "RoleAuthoritiesDto.RoleAuthorityDto(name=" + this.getName() + ", available=" + this.isAvailable() + ", fields=" + this.getFields() + ", type=" + this.getType() + ")";
        }

        public static class RoleAuthorityDtoBuilder {
            private String name;
            private boolean available;
            private ImmutableList<String> fields;
            private Fields.Type type;

            RoleAuthorityDtoBuilder() {
            }

            public RoleAuthorityDtoBuilder name(String name) {
                this.name = name;
                return this;
            }

            public RoleAuthorityDtoBuilder available(boolean available) {
                this.available = available;
                return this;
            }

            public RoleAuthorityDtoBuilder fields(ImmutableList<String> fields) {
                this.fields = fields;
                return this;
            }

            public RoleAuthorityDtoBuilder type(Fields.Type type) {
                this.type = type;
                return this;
            }

            public RoleAuthorityDto build() {
                return new RoleAuthorityDto(this.name, this.available, this.fields, this.type);
            }

            public String toString() {
                return "RoleAuthoritiesDto.RoleAuthorityDto.RoleAuthorityDtoBuilder(name=" + this.name + ", available=" + this.available + ", fields=" + this.fields + ", type=" + this.type + ")";
            }
        }
    }
}

