/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.security.engine.core;

import digital.nedra.commons.starter.security.engine.core.ContextConfigure;
import digital.nedra.commons.starter.security.engine.core.Fields;
import digital.nedra.commons.starter.security.engine.core.RoleBuilder;
import digital.nedra.commons.starter.security.engine.core.RoleHandler;

public interface AuthorityConfigurer {
    public ContextConfigure context();

    public RoleBuilder forbidden();

    public RoleBuilder and();

    public RoleHandler build();

    public static class DefaultAuthorityConfigurer
    implements AuthorityConfigurer {
        String name;
        boolean available = true;
        Fields fields;
        RoleBuilder parent;

        @Override
        public ContextConfigure context() {
            ContextConfigure.DefaultContextConfigure configure = new ContextConfigure.DefaultContextConfigure();
            configure.setParent(this.parent);
            return configure;
        }

        @Override
        public RoleBuilder forbidden() {
            this.available = false;
            return this.parent.and();
        }

        @Override
        public RoleBuilder and() {
            return this.parent.and();
        }

        @Override
        public RoleHandler build() {
            this.parent.and();
            return this.parent.build();
        }

        void setName(String name) {
            this.name = name;
        }

        void setAvailable(boolean available) {
            this.available = available;
        }

        void setFields(Fields fields) {
            this.fields = fields;
        }

        void setParent(RoleBuilder parent) {
            this.parent = parent;
        }

        String getName() {
            return this.name;
        }

        boolean isAvailable() {
            return this.available;
        }

        Fields getFields() {
            return this.fields;
        }

        RoleBuilder getParent() {
            return this.parent;
        }
    }
}

