package zio.aws.machinelearning.model
import scala.jdk.CollectionConverters.*
sealed trait MLModelFilterVariable {
  def unwrap: software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable
}
object MLModelFilterVariable {
  def wrap(
      value: software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable
  ): zio.aws.machinelearning.model.MLModelFilterVariable = value match {
    case software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable.CREATED_AT =>
      val r = CreatedAt
      r
    case software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable.LAST_UPDATED_AT =>
      val r = LastUpdatedAt
      r
    case software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable.STATUS =>
      val r = Status
      r
    case software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable.NAME =>
      val r = Name
      r
    case software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable.IAM_USER =>
      val r = IAMUser
      r
    case software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable.TRAINING_DATA_SOURCE_ID =>
      val r = TrainingDataSourceId
      r
    case software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable.REALTIME_ENDPOINT_STATUS =>
      val r = RealtimeEndpointStatus
      r
    case software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable.ML_MODEL_TYPE =>
      val r = MLModelType
      r
    case software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable.ALGORITHM =>
      val r = Algorithm
      r
    case software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable.TRAINING_DATA_URI =>
      val r = TrainingDataURI
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.machinelearning.model.MLModelFilterVariable {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable =
      software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable.UNKNOWN_TO_SDK_VERSION
  }
  case object CreatedAt
      extends zio.aws.machinelearning.model.MLModelFilterVariable {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable =
      software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable.CREATED_AT
  }
  case object LastUpdatedAt
      extends zio.aws.machinelearning.model.MLModelFilterVariable {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable =
      software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable.LAST_UPDATED_AT
  }
  case object Status
      extends zio.aws.machinelearning.model.MLModelFilterVariable {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable =
      software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable.STATUS
  }
  case object Name extends zio.aws.machinelearning.model.MLModelFilterVariable {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable =
      software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable.NAME
  }
  case object IAMUser
      extends zio.aws.machinelearning.model.MLModelFilterVariable {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable =
      software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable.IAM_USER
  }
  case object TrainingDataSourceId
      extends zio.aws.machinelearning.model.MLModelFilterVariable {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable =
      software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable.TRAINING_DATA_SOURCE_ID
  }
  case object RealtimeEndpointStatus
      extends zio.aws.machinelearning.model.MLModelFilterVariable {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable =
      software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable.REALTIME_ENDPOINT_STATUS
  }
  case object MLModelType
      extends zio.aws.machinelearning.model.MLModelFilterVariable {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable =
      software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable.ML_MODEL_TYPE
  }
  case object Algorithm
      extends zio.aws.machinelearning.model.MLModelFilterVariable {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable =
      software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable.ALGORITHM
  }
  case object TrainingDataURI
      extends zio.aws.machinelearning.model.MLModelFilterVariable {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable =
      software.amazon.awssdk.services.machinelearning.model.MLModelFilterVariable.TRAINING_DATA_URI
  }
}
