package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.machinelearning.model.primitives.EntityId
import scala.jdk.CollectionConverters.*
final case class GetBatchPredictionRequest(batchPredictionId: EntityId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.GetBatchPredictionRequest = {
    import GetBatchPredictionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.GetBatchPredictionRequest
      .builder()
      .batchPredictionId(EntityId.unwrap(batchPredictionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.GetBatchPredictionRequest.ReadOnly =
    zio.aws.machinelearning.model.GetBatchPredictionRequest
      .wrap(buildAwsValue())
}
object GetBatchPredictionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.GetBatchPredictionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.GetBatchPredictionRequest =
      zio.aws.machinelearning.model.GetBatchPredictionRequest(batchPredictionId)
    def batchPredictionId: EntityId
    def getBatchPredictionId: ZIO[Any, Nothing, EntityId] =
      ZIO.succeed(batchPredictionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.GetBatchPredictionRequest
  ) extends zio.aws.machinelearning.model.GetBatchPredictionRequest.ReadOnly {
    override val batchPredictionId: EntityId =
      zio.aws.machinelearning.model.primitives
        .EntityId(impl.batchPredictionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.GetBatchPredictionRequest
  ): zio.aws.machinelearning.model.GetBatchPredictionRequest.ReadOnly =
    new Wrapper(impl)
}
