package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.machinelearning.model.primitives.EntityId
import scala.jdk.CollectionConverters.*
final case class DeleteRealtimeEndpointRequest(mlModelId: EntityId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.DeleteRealtimeEndpointRequest = {
    import DeleteRealtimeEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.DeleteRealtimeEndpointRequest
      .builder()
      .mlModelId(EntityId.unwrap(mlModelId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.DeleteRealtimeEndpointRequest.ReadOnly =
    zio.aws.machinelearning.model.DeleteRealtimeEndpointRequest
      .wrap(buildAwsValue())
}
object DeleteRealtimeEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.DeleteRealtimeEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.machinelearning.model.DeleteRealtimeEndpointRequest =
      zio.aws.machinelearning.model.DeleteRealtimeEndpointRequest(mlModelId)
    def mlModelId: EntityId
    def getMlModelId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(mlModelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.DeleteRealtimeEndpointRequest
  ) extends zio.aws.machinelearning.model.DeleteRealtimeEndpointRequest.ReadOnly {
    override val mlModelId: EntityId =
      zio.aws.machinelearning.model.primitives.EntityId(impl.mlModelId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.DeleteRealtimeEndpointRequest
  ): zio.aws.machinelearning.model.DeleteRealtimeEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
