package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.machinelearning.model.primitives.EntityId
import scala.jdk.CollectionConverters.*
final case class CreateRealtimeEndpointRequest(mlModelId: EntityId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.CreateRealtimeEndpointRequest = {
    import CreateRealtimeEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.CreateRealtimeEndpointRequest
      .builder()
      .mlModelId(EntityId.unwrap(mlModelId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.CreateRealtimeEndpointRequest.ReadOnly =
    zio.aws.machinelearning.model.CreateRealtimeEndpointRequest
      .wrap(buildAwsValue())
}
object CreateRealtimeEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.CreateRealtimeEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.machinelearning.model.CreateRealtimeEndpointRequest =
      zio.aws.machinelearning.model.CreateRealtimeEndpointRequest(mlModelId)
    def mlModelId: EntityId
    def getMlModelId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(mlModelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.CreateRealtimeEndpointRequest
  ) extends zio.aws.machinelearning.model.CreateRealtimeEndpointRequest.ReadOnly {
    override val mlModelId: EntityId =
      zio.aws.machinelearning.model.primitives.EntityId(impl.mlModelId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.CreateRealtimeEndpointRequest
  ): zio.aws.machinelearning.model.CreateRealtimeEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
