package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.machinelearning.model.primitives.{EntityName, EntityId}
import scala.jdk.CollectionConverters.*
final case class UpdateDataSourceRequest(
    dataSourceId: EntityId,
    dataSourceName: EntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.UpdateDataSourceRequest = {
    import UpdateDataSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.UpdateDataSourceRequest
      .builder()
      .dataSourceId(EntityId.unwrap(dataSourceId): java.lang.String)
      .dataSourceName(EntityName.unwrap(dataSourceName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.UpdateDataSourceRequest.ReadOnly =
    zio.aws.machinelearning.model.UpdateDataSourceRequest.wrap(buildAwsValue())
}
object UpdateDataSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.UpdateDataSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.UpdateDataSourceRequest =
      zio.aws.machinelearning.model
        .UpdateDataSourceRequest(dataSourceId, dataSourceName)
    def dataSourceId: EntityId
    def dataSourceName: EntityName
    def getDataSourceId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(dataSourceId)
    def getDataSourceName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(dataSourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.UpdateDataSourceRequest
  ) extends zio.aws.machinelearning.model.UpdateDataSourceRequest.ReadOnly {
    override val dataSourceId: EntityId =
      zio.aws.machinelearning.model.primitives.EntityId(impl.dataSourceId())
    override val dataSourceName: EntityName =
      zio.aws.machinelearning.model.primitives.EntityName(impl.dataSourceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.UpdateDataSourceRequest
  ): zio.aws.machinelearning.model.UpdateDataSourceRequest.ReadOnly =
    new Wrapper(impl)
}
