package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.{
  DataSchema,
  DataRearrangement,
  EDPServiceRole,
  S3Url,
  EDPResourceRole,
  EDPSecurityGroupId,
  RDSSelectSqlQuery,
  EDPSubnetId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RDSDataSpec(
    databaseInformation: zio.aws.machinelearning.model.RDSDatabase,
    selectSqlQuery: RDSSelectSqlQuery,
    databaseCredentials: zio.aws.machinelearning.model.RDSDatabaseCredentials,
    s3StagingLocation: S3Url,
    dataRearrangement: Optional[DataRearrangement] = Optional.Absent,
    dataSchema: Optional[DataSchema] = Optional.Absent,
    dataSchemaUri: Optional[S3Url] = Optional.Absent,
    resourceRole: EDPResourceRole,
    serviceRole: EDPServiceRole,
    subnetId: EDPSubnetId,
    securityGroupIds: Iterable[EDPSecurityGroupId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.RDSDataSpec = {
    import RDSDataSpec.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.RDSDataSpec
      .builder()
      .databaseInformation(databaseInformation.buildAwsValue())
      .selectSqlQuery(
        RDSSelectSqlQuery.unwrap(selectSqlQuery): java.lang.String
      )
      .databaseCredentials(databaseCredentials.buildAwsValue())
      .s3StagingLocation(S3Url.unwrap(s3StagingLocation): java.lang.String)
      .optionallyWith(
        dataRearrangement.map(value =>
          DataRearrangement.unwrap(value): java.lang.String
        )
      )(_.dataRearrangement)
      .optionallyWith(
        dataSchema.map(value => DataSchema.unwrap(value): java.lang.String)
      )(_.dataSchema)
      .optionallyWith(
        dataSchemaUri.map(value => S3Url.unwrap(value): java.lang.String)
      )(_.dataSchemaUri)
      .resourceRole(EDPResourceRole.unwrap(resourceRole): java.lang.String)
      .serviceRole(EDPServiceRole.unwrap(serviceRole): java.lang.String)
      .subnetId(EDPSubnetId.unwrap(subnetId): java.lang.String)
      .securityGroupIds(securityGroupIds.map { item =>
        EDPSecurityGroupId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.RDSDataSpec.ReadOnly =
    zio.aws.machinelearning.model.RDSDataSpec.wrap(buildAwsValue())
}
object RDSDataSpec {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.RDSDataSpec
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.RDSDataSpec =
      zio.aws.machinelearning.model.RDSDataSpec(
        databaseInformation.asEditable,
        selectSqlQuery,
        databaseCredentials.asEditable,
        s3StagingLocation,
        dataRearrangement.map(value => value),
        dataSchema.map(value => value),
        dataSchemaUri.map(value => value),
        resourceRole,
        serviceRole,
        subnetId,
        securityGroupIds
      )
    def databaseInformation: zio.aws.machinelearning.model.RDSDatabase.ReadOnly
    def selectSqlQuery: RDSSelectSqlQuery
    def databaseCredentials
        : zio.aws.machinelearning.model.RDSDatabaseCredentials.ReadOnly
    def s3StagingLocation: S3Url
    def dataRearrangement: Optional[DataRearrangement]
    def dataSchema: Optional[DataSchema]
    def dataSchemaUri: Optional[S3Url]
    def resourceRole: EDPResourceRole
    def serviceRole: EDPServiceRole
    def subnetId: EDPSubnetId
    def securityGroupIds: List[EDPSecurityGroupId]
    def getDatabaseInformation: ZIO[
      Any,
      Nothing,
      zio.aws.machinelearning.model.RDSDatabase.ReadOnly
    ] = ZIO.succeed(databaseInformation)
    def getSelectSqlQuery: ZIO[Any, Nothing, RDSSelectSqlQuery] =
      ZIO.succeed(selectSqlQuery)
    def getDatabaseCredentials: ZIO[
      Any,
      Nothing,
      zio.aws.machinelearning.model.RDSDatabaseCredentials.ReadOnly
    ] = ZIO.succeed(databaseCredentials)
    def getS3StagingLocation: ZIO[Any, Nothing, S3Url] =
      ZIO.succeed(s3StagingLocation)
    def getDataRearrangement: ZIO[Any, AwsError, DataRearrangement] =
      AwsError.unwrapOptionField("dataRearrangement", dataRearrangement)
    def getDataSchema: ZIO[Any, AwsError, DataSchema] =
      AwsError.unwrapOptionField("dataSchema", dataSchema)
    def getDataSchemaUri: ZIO[Any, AwsError, S3Url] =
      AwsError.unwrapOptionField("dataSchemaUri", dataSchemaUri)
    def getResourceRole: ZIO[Any, Nothing, EDPResourceRole] =
      ZIO.succeed(resourceRole)
    def getServiceRole: ZIO[Any, Nothing, EDPServiceRole] =
      ZIO.succeed(serviceRole)
    def getSubnetId: ZIO[Any, Nothing, EDPSubnetId] = ZIO.succeed(subnetId)
    def getSecurityGroupIds: ZIO[Any, Nothing, List[EDPSecurityGroupId]] =
      ZIO.succeed(securityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.RDSDataSpec
  ) extends zio.aws.machinelearning.model.RDSDataSpec.ReadOnly {
    override val databaseInformation
        : zio.aws.machinelearning.model.RDSDatabase.ReadOnly =
      zio.aws.machinelearning.model.RDSDatabase.wrap(impl.databaseInformation())
    override val selectSqlQuery: RDSSelectSqlQuery =
      zio.aws.machinelearning.model.primitives
        .RDSSelectSqlQuery(impl.selectSqlQuery())
    override val databaseCredentials
        : zio.aws.machinelearning.model.RDSDatabaseCredentials.ReadOnly =
      zio.aws.machinelearning.model.RDSDatabaseCredentials
        .wrap(impl.databaseCredentials())
    override val s3StagingLocation: S3Url =
      zio.aws.machinelearning.model.primitives.S3Url(impl.s3StagingLocation())
    override val dataRearrangement: Optional[DataRearrangement] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataRearrangement())
        .map(value =>
          zio.aws.machinelearning.model.primitives.DataRearrangement(value)
        )
    override val dataSchema: Optional[DataSchema] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSchema())
      .map(value => zio.aws.machinelearning.model.primitives.DataSchema(value))
    override val dataSchemaUri: Optional[S3Url] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSchemaUri())
      .map(value => zio.aws.machinelearning.model.primitives.S3Url(value))
    override val resourceRole: EDPResourceRole =
      zio.aws.machinelearning.model.primitives
        .EDPResourceRole(impl.resourceRole())
    override val serviceRole: EDPServiceRole =
      zio.aws.machinelearning.model.primitives
        .EDPServiceRole(impl.serviceRole())
    override val subnetId: EDPSubnetId =
      zio.aws.machinelearning.model.primitives.EDPSubnetId(impl.subnetId())
    override val securityGroupIds: List[EDPSecurityGroupId] = impl
      .securityGroupIds()
      .asScala
      .map { item =>
        zio.aws.machinelearning.model.primitives.EDPSecurityGroupId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.RDSDataSpec
  ): zio.aws.machinelearning.model.RDSDataSpec.ReadOnly = new Wrapper(impl)
}
