package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.machinelearning.model.primitives.{
  VipURL,
  VariableValue,
  VariableName,
  EntityId
}
import scala.jdk.CollectionConverters.*
final case class PredictRequest(
    mlModelId: EntityId,
    record: Map[VariableName, VariableValue],
    predictEndpoint: VipURL
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.PredictRequest = {
    import PredictRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.PredictRequest
      .builder()
      .mlModelId(EntityId.unwrap(mlModelId): java.lang.String)
      .record(
        record
          .map({ case (key, value) =>
            (VariableName.unwrap(key): java.lang.String) -> (VariableValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .predictEndpoint(VipURL.unwrap(predictEndpoint): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.PredictRequest.ReadOnly =
    zio.aws.machinelearning.model.PredictRequest.wrap(buildAwsValue())
}
object PredictRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.PredictRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.PredictRequest =
      zio.aws.machinelearning.model
        .PredictRequest(mlModelId, record, predictEndpoint)
    def mlModelId: EntityId
    def record: Map[VariableName, VariableValue]
    def predictEndpoint: VipURL
    def getMlModelId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(mlModelId)
    def getRecord: ZIO[Any, Nothing, Map[VariableName, VariableValue]] =
      ZIO.succeed(record)
    def getPredictEndpoint: ZIO[Any, Nothing, VipURL] =
      ZIO.succeed(predictEndpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.PredictRequest
  ) extends zio.aws.machinelearning.model.PredictRequest.ReadOnly {
    override val mlModelId: EntityId =
      zio.aws.machinelearning.model.primitives.EntityId(impl.mlModelId())
    override val record: Map[VariableName, VariableValue] = impl
      .record()
      .asScala
      .map({ case (key, value) =>
        zio.aws.machinelearning.model.primitives.VariableName(
          key
        ) -> zio.aws.machinelearning.model.primitives.VariableValue(value)
      })
      .toMap
    override val predictEndpoint: VipURL =
      zio.aws.machinelearning.model.primitives.VipURL(impl.predictEndpoint())
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.PredictRequest
  ): zio.aws.machinelearning.model.PredictRequest.ReadOnly = new Wrapper(impl)
}
