package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.EntityId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteMlModelResponse(
    mlModelId: Optional[EntityId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.DeleteMlModelResponse = {
    import DeleteMlModelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.DeleteMlModelResponse
      .builder()
      .optionallyWith(
        mlModelId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.mlModelId)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.DeleteMlModelResponse.ReadOnly =
    zio.aws.machinelearning.model.DeleteMlModelResponse.wrap(buildAwsValue())
}
object DeleteMlModelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.DeleteMlModelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.DeleteMlModelResponse =
      zio.aws.machinelearning.model
        .DeleteMlModelResponse(mlModelId.map(value => value))
    def mlModelId: Optional[EntityId]
    def getMlModelId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("mlModelId", mlModelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.DeleteMlModelResponse
  ) extends zio.aws.machinelearning.model.DeleteMlModelResponse.ReadOnly {
    override val mlModelId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.mlModelId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.DeleteMlModelResponse
  ): zio.aws.machinelearning.model.DeleteMlModelResponse.ReadOnly = new Wrapper(
    impl
  )
}
