package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.{EntityName, EntityId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateEvaluationRequest(
    evaluationId: EntityId,
    evaluationName: Optional[EntityName] = Optional.Absent,
    mlModelId: EntityId,
    evaluationDataSourceId: EntityId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.CreateEvaluationRequest = {
    import CreateEvaluationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.CreateEvaluationRequest
      .builder()
      .evaluationId(EntityId.unwrap(evaluationId): java.lang.String)
      .optionallyWith(
        evaluationName.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.evaluationName)
      .mlModelId(EntityId.unwrap(mlModelId): java.lang.String)
      .evaluationDataSourceId(
        EntityId.unwrap(evaluationDataSourceId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.CreateEvaluationRequest.ReadOnly =
    zio.aws.machinelearning.model.CreateEvaluationRequest.wrap(buildAwsValue())
}
object CreateEvaluationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.CreateEvaluationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.CreateEvaluationRequest =
      zio.aws.machinelearning.model.CreateEvaluationRequest(
        evaluationId,
        evaluationName.map(value => value),
        mlModelId,
        evaluationDataSourceId
      )
    def evaluationId: EntityId
    def evaluationName: Optional[EntityName]
    def mlModelId: EntityId
    def evaluationDataSourceId: EntityId
    def getEvaluationId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(evaluationId)
    def getEvaluationName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("evaluationName", evaluationName)
    def getMlModelId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(mlModelId)
    def getEvaluationDataSourceId: ZIO[Any, Nothing, EntityId] =
      ZIO.succeed(evaluationDataSourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.CreateEvaluationRequest
  ) extends zio.aws.machinelearning.model.CreateEvaluationRequest.ReadOnly {
    override val evaluationId: EntityId =
      zio.aws.machinelearning.model.primitives.EntityId(impl.evaluationId())
    override val evaluationName: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.evaluationName())
      .map(value => zio.aws.machinelearning.model.primitives.EntityName(value))
    override val mlModelId: EntityId =
      zio.aws.machinelearning.model.primitives.EntityId(impl.mlModelId())
    override val evaluationDataSourceId: EntityId =
      zio.aws.machinelearning.model.primitives
        .EntityId(impl.evaluationDataSourceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.CreateEvaluationRequest
  ): zio.aws.machinelearning.model.CreateEvaluationRequest.ReadOnly =
    new Wrapper(impl)
}
