package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.machinelearning.model.primitives.{EntityId, TagKey}
import scala.jdk.CollectionConverters.*
final case class DeleteTagsRequest(
    tagKeys: Iterable[TagKey],
    resourceId: EntityId,
    resourceType: zio.aws.machinelearning.model.TaggableResourceType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.DeleteTagsRequest = {
    import DeleteTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.DeleteTagsRequest
      .builder()
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .resourceId(EntityId.unwrap(resourceId): java.lang.String)
      .resourceType(resourceType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.DeleteTagsRequest.ReadOnly =
    zio.aws.machinelearning.model.DeleteTagsRequest.wrap(buildAwsValue())
}
object DeleteTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.DeleteTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.DeleteTagsRequest =
      zio.aws.machinelearning.model
        .DeleteTagsRequest(tagKeys, resourceId, resourceType)
    def tagKeys: List[TagKey]
    def resourceId: EntityId
    def resourceType: zio.aws.machinelearning.model.TaggableResourceType
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
    def getResourceId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(resourceId)
    def getResourceType: ZIO[
      Any,
      Nothing,
      zio.aws.machinelearning.model.TaggableResourceType
    ] = ZIO.succeed(resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.DeleteTagsRequest
  ) extends zio.aws.machinelearning.model.DeleteTagsRequest.ReadOnly {
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.machinelearning.model.primitives.TagKey(item)
      }
      .toList
    override val resourceId: EntityId =
      zio.aws.machinelearning.model.primitives.EntityId(impl.resourceId())
    override val resourceType
        : zio.aws.machinelearning.model.TaggableResourceType =
      zio.aws.machinelearning.model.TaggableResourceType
        .wrap(impl.resourceType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.DeleteTagsRequest
  ): zio.aws.machinelearning.model.DeleteTagsRequest.ReadOnly = new Wrapper(
    impl
  )
}
