package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.machinelearning.model.primitives.EntityId
import scala.jdk.CollectionConverters.*
final case class DeleteDataSourceRequest(dataSourceId: EntityId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.DeleteDataSourceRequest = {
    import DeleteDataSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.DeleteDataSourceRequest
      .builder()
      .dataSourceId(EntityId.unwrap(dataSourceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.DeleteDataSourceRequest.ReadOnly =
    zio.aws.machinelearning.model.DeleteDataSourceRequest.wrap(buildAwsValue())
}
object DeleteDataSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.DeleteDataSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.DeleteDataSourceRequest =
      zio.aws.machinelearning.model.DeleteDataSourceRequest(dataSourceId)
    def dataSourceId: EntityId
    def getDataSourceId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(dataSourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.DeleteDataSourceRequest
  ) extends zio.aws.machinelearning.model.DeleteDataSourceRequest.ReadOnly {
    override val dataSourceId: EntityId =
      zio.aws.machinelearning.model.primitives.EntityId(impl.dataSourceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.DeleteDataSourceRequest
  ): zio.aws.machinelearning.model.DeleteDataSourceRequest.ReadOnly =
    new Wrapper(impl)
}
