package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.EntityId
import scala.jdk.CollectionConverters.*
final case class UpdateBatchPredictionResponse(
    batchPredictionId: Option[EntityId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.UpdateBatchPredictionResponse = {
    import UpdateBatchPredictionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.UpdateBatchPredictionResponse
      .builder()
      .optionallyWith(
        batchPredictionId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.batchPredictionId)
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.UpdateBatchPredictionResponse.ReadOnly =
    zio.aws.machinelearning.model.UpdateBatchPredictionResponse
      .wrap(buildAwsValue())
}
object UpdateBatchPredictionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.UpdateBatchPredictionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.machinelearning.model.UpdateBatchPredictionResponse =
      zio.aws.machinelearning.model
        .UpdateBatchPredictionResponse(batchPredictionId.map(value => value))
    def batchPredictionId: Option[EntityId]
    def getBatchPredictionId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("batchPredictionId", batchPredictionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.UpdateBatchPredictionResponse
  ) extends zio.aws.machinelearning.model.UpdateBatchPredictionResponse.ReadOnly {
    override val batchPredictionId: Option[EntityId] = scala
      .Option(impl.batchPredictionId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.UpdateBatchPredictionResponse
  ): zio.aws.machinelearning.model.UpdateBatchPredictionResponse.ReadOnly =
    new Wrapper(impl)
}
