package zio.aws.machinelearning.model
import scala.jdk.CollectionConverters.*
sealed trait TaggableResourceType {
  def unwrap: software.amazon.awssdk.services.machinelearning.model.TaggableResourceType
}
object TaggableResourceType {
  def wrap(
      value: software.amazon.awssdk.services.machinelearning.model.TaggableResourceType
  ): zio.aws.machinelearning.model.TaggableResourceType = value match {
    case software.amazon.awssdk.services.machinelearning.model.TaggableResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.machinelearning.model.TaggableResourceType.BATCH_PREDICTION =>
      val r = BatchPrediction
      r
    case software.amazon.awssdk.services.machinelearning.model.TaggableResourceType.DATA_SOURCE =>
      val r = DataSource
      r
    case software.amazon.awssdk.services.machinelearning.model.TaggableResourceType.EVALUATION =>
      val r = Evaluation
      r
    case software.amazon.awssdk.services.machinelearning.model.TaggableResourceType.ML_MODEL =>
      val r = MLModel
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.machinelearning.model.TaggableResourceType {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.TaggableResourceType =
      software.amazon.awssdk.services.machinelearning.model.TaggableResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object BatchPrediction
      extends zio.aws.machinelearning.model.TaggableResourceType {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.TaggableResourceType =
      software.amazon.awssdk.services.machinelearning.model.TaggableResourceType.BATCH_PREDICTION
  }
  case object DataSource
      extends zio.aws.machinelearning.model.TaggableResourceType {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.TaggableResourceType =
      software.amazon.awssdk.services.machinelearning.model.TaggableResourceType.DATA_SOURCE
  }
  case object Evaluation
      extends zio.aws.machinelearning.model.TaggableResourceType {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.TaggableResourceType =
      software.amazon.awssdk.services.machinelearning.model.TaggableResourceType.EVALUATION
  }
  case object MLModel
      extends zio.aws.machinelearning.model.TaggableResourceType {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.TaggableResourceType =
      software.amazon.awssdk.services.machinelearning.model.TaggableResourceType.ML_MODEL
  }
}
