package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.machinelearning.model.primitives.{
  RedshiftDatabasePassword,
  RedshiftDatabaseUsername
}
import scala.jdk.CollectionConverters.*
final case class RedshiftDatabaseCredentials(
    username: RedshiftDatabaseUsername,
    password: RedshiftDatabasePassword
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.RedshiftDatabaseCredentials = {
    import RedshiftDatabaseCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.RedshiftDatabaseCredentials
      .builder()
      .username(RedshiftDatabaseUsername.unwrap(username): java.lang.String)
      .password(RedshiftDatabasePassword.unwrap(password): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.RedshiftDatabaseCredentials.ReadOnly =
    zio.aws.machinelearning.model.RedshiftDatabaseCredentials
      .wrap(buildAwsValue())
}
object RedshiftDatabaseCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.RedshiftDatabaseCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.RedshiftDatabaseCredentials =
      zio.aws.machinelearning.model
        .RedshiftDatabaseCredentials(username, password)
    def username: RedshiftDatabaseUsername
    def password: RedshiftDatabasePassword
    def getUsername: ZIO[Any, Nothing, RedshiftDatabaseUsername] =
      ZIO.succeed(username)
    def getPassword: ZIO[Any, Nothing, RedshiftDatabasePassword] =
      ZIO.succeed(password)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.RedshiftDatabaseCredentials
  ) extends zio.aws.machinelearning.model.RedshiftDatabaseCredentials.ReadOnly {
    override val username: RedshiftDatabaseUsername =
      zio.aws.machinelearning.model.primitives
        .RedshiftDatabaseUsername(impl.username())
    override val password: RedshiftDatabasePassword =
      zio.aws.machinelearning.model.primitives
        .RedshiftDatabasePassword(impl.password())
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.RedshiftDatabaseCredentials
  ): zio.aws.machinelearning.model.RedshiftDatabaseCredentials.ReadOnly =
    new Wrapper(impl)
}
