package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.{
  EDPServiceRole,
  EDPResourceRole,
  RDSDatabaseUsername,
  EDPPipelineId,
  RDSSelectSqlQuery
}
import scala.jdk.CollectionConverters.*
final case class RDSMetadata(
    database: Option[zio.aws.machinelearning.model.RDSDatabase] = None,
    databaseUserName: Option[RDSDatabaseUsername] = None,
    selectSqlQuery: Option[RDSSelectSqlQuery] = None,
    resourceRole: Option[EDPResourceRole] = None,
    serviceRole: Option[EDPServiceRole] = None,
    dataPipelineId: Option[EDPPipelineId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.RDSMetadata = {
    import RDSMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.RDSMetadata
      .builder()
      .optionallyWith(database.map(value => value.buildAwsValue()))(_.database)
      .optionallyWith(
        databaseUserName.map(value =>
          RDSDatabaseUsername.unwrap(value): java.lang.String
        )
      )(_.databaseUserName)
      .optionallyWith(
        selectSqlQuery.map(value =>
          RDSSelectSqlQuery.unwrap(value): java.lang.String
        )
      )(_.selectSqlQuery)
      .optionallyWith(
        resourceRole.map(value =>
          EDPResourceRole.unwrap(value): java.lang.String
        )
      )(_.resourceRole)
      .optionallyWith(
        serviceRole.map(value => EDPServiceRole.unwrap(value): java.lang.String)
      )(_.serviceRole)
      .optionallyWith(
        dataPipelineId.map(value =>
          EDPPipelineId.unwrap(value): java.lang.String
        )
      )(_.dataPipelineId)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.RDSMetadata.ReadOnly =
    zio.aws.machinelearning.model.RDSMetadata.wrap(buildAwsValue())
}
object RDSMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.RDSMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.RDSMetadata =
      zio.aws.machinelearning.model.RDSMetadata(
        database.map(value => value.asEditable),
        databaseUserName.map(value => value),
        selectSqlQuery.map(value => value),
        resourceRole.map(value => value),
        serviceRole.map(value => value),
        dataPipelineId.map(value => value)
      )
    def database: Option[zio.aws.machinelearning.model.RDSDatabase.ReadOnly]
    def databaseUserName: Option[RDSDatabaseUsername]
    def selectSqlQuery: Option[RDSSelectSqlQuery]
    def resourceRole: Option[EDPResourceRole]
    def serviceRole: Option[EDPServiceRole]
    def dataPipelineId: Option[EDPPipelineId]
    def getDatabase: ZIO[
      Any,
      AwsError,
      zio.aws.machinelearning.model.RDSDatabase.ReadOnly
    ] = AwsError.unwrapOptionField("database", database)
    def getDatabaseUserName: ZIO[Any, AwsError, RDSDatabaseUsername] =
      AwsError.unwrapOptionField("databaseUserName", databaseUserName)
    def getSelectSqlQuery: ZIO[Any, AwsError, RDSSelectSqlQuery] =
      AwsError.unwrapOptionField("selectSqlQuery", selectSqlQuery)
    def getResourceRole: ZIO[Any, AwsError, EDPResourceRole] =
      AwsError.unwrapOptionField("resourceRole", resourceRole)
    def getServiceRole: ZIO[Any, AwsError, EDPServiceRole] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getDataPipelineId: ZIO[Any, AwsError, EDPPipelineId] =
      AwsError.unwrapOptionField("dataPipelineId", dataPipelineId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.RDSMetadata
  ) extends zio.aws.machinelearning.model.RDSMetadata.ReadOnly {
    override val database
        : Option[zio.aws.machinelearning.model.RDSDatabase.ReadOnly] = scala
      .Option(impl.database())
      .map(value => zio.aws.machinelearning.model.RDSDatabase.wrap(value))
    override val databaseUserName: Option[RDSDatabaseUsername] = scala
      .Option(impl.databaseUserName())
      .map(value =>
        zio.aws.machinelearning.model.primitives.RDSDatabaseUsername(value)
      )
    override val selectSqlQuery: Option[RDSSelectSqlQuery] = scala
      .Option(impl.selectSqlQuery())
      .map(value =>
        zio.aws.machinelearning.model.primitives.RDSSelectSqlQuery(value)
      )
    override val resourceRole: Option[EDPResourceRole] = scala
      .Option(impl.resourceRole())
      .map(value =>
        zio.aws.machinelearning.model.primitives.EDPResourceRole(value)
      )
    override val serviceRole: Option[EDPServiceRole] = scala
      .Option(impl.serviceRole())
      .map(value =>
        zio.aws.machinelearning.model.primitives.EDPServiceRole(value)
      )
    override val dataPipelineId: Option[EDPPipelineId] = scala
      .Option(impl.dataPipelineId())
      .map(value =>
        zio.aws.machinelearning.model.primitives.EDPPipelineId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.RDSMetadata
  ): zio.aws.machinelearning.model.RDSMetadata.ReadOnly = new Wrapper(impl)
}
