package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.machinelearning.model.primitives.EntityId
import scala.jdk.CollectionConverters.*
final case class DeleteBatchPredictionRequest(batchPredictionId: EntityId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.DeleteBatchPredictionRequest = {
    import DeleteBatchPredictionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.DeleteBatchPredictionRequest
      .builder()
      .batchPredictionId(EntityId.unwrap(batchPredictionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.DeleteBatchPredictionRequest.ReadOnly =
    zio.aws.machinelearning.model.DeleteBatchPredictionRequest
      .wrap(buildAwsValue())
}
object DeleteBatchPredictionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.DeleteBatchPredictionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.DeleteBatchPredictionRequest =
      zio.aws.machinelearning.model
        .DeleteBatchPredictionRequest(batchPredictionId)
    def batchPredictionId: EntityId
    def getBatchPredictionId: ZIO[Any, Nothing, EntityId] =
      ZIO.succeed(batchPredictionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.DeleteBatchPredictionRequest
  ) extends zio.aws.machinelearning.model.DeleteBatchPredictionRequest.ReadOnly {
    override val batchPredictionId: EntityId =
      zio.aws.machinelearning.model.primitives
        .EntityId(impl.batchPredictionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.DeleteBatchPredictionRequest
  ): zio.aws.machinelearning.model.DeleteBatchPredictionRequest.ReadOnly =
    new Wrapper(impl)
}
