package zio.aws.machinelearning
import zio.aws.machinelearning.model.GetMlModelResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.machinelearning.{
  MachineLearningAsyncClientBuilder,
  MachineLearningAsyncClient
}
import software.amazon.awssdk.services.machinelearning.model.{
  CreateMlModelResponse,
  DataSource,
  DescribeEvaluationsRequest,
  CreateEvaluationRequest,
  GetEvaluationResponse,
  CreateBatchPredictionResponse,
  DescribeBatchPredictionsRequest,
  PredictResponse,
  UpdateDataSourceRequest,
  UpdateMlModelResponse,
  CreateRealtimeEndpointResponse,
  DeleteTagsRequest,
  MLModel,
  UpdateBatchPredictionRequest,
  CreateEvaluationResponse,
  PredictRequest,
  DeleteRealtimeEndpointResponse,
  CreateDataSourceFromRdsRequest,
  DeleteTagsResponse,
  GetEvaluationRequest,
  CreateDataSourceFromS3Response,
  DeleteDataSourceResponse,
  GetBatchPredictionResponse,
  CreateBatchPredictionRequest,
  CreateDataSourceFromRedshiftResponse,
  DeleteMlModelResponse,
  GetBatchPredictionRequest,
  GetDataSourceResponse,
  DeleteRealtimeEndpointRequest,
  UpdateEvaluationResponse,
  UpdateMlModelRequest,
  DescribeMlModelsRequest,
  CreateDataSourceFromRdsResponse,
  DeleteBatchPredictionRequest,
  UpdateEvaluationRequest,
  GetMlModelResponse,
  GetDataSourceRequest,
  AddTagsRequest,
  DescribeEvaluationsResponse,
  DeleteMlModelRequest,
  DeleteBatchPredictionResponse,
  DeleteEvaluationRequest,
  UpdateDataSourceResponse,
  GetMlModelRequest,
  DescribeDataSourcesRequest,
  AddTagsResponse,
  DescribeTagsRequest,
  DeleteDataSourceRequest,
  DescribeBatchPredictionsResponse,
  DeleteEvaluationResponse,
  CreateDataSourceFromRedshiftRequest,
  CreateDataSourceFromS3Request,
  Evaluation,
  DescribeTagsResponse,
  DescribeDataSourcesResponse,
  DescribeMlModelsResponse,
  UpdateBatchPredictionResponse,
  BatchPrediction,
  CreateRealtimeEndpointRequest,
  CreateMlModelRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait MachineLearning extends AspectSupport[MachineLearning] {
  val api: MachineLearningAsyncClient
  def updateBatchPrediction(
      request: zio.aws.machinelearning.model.UpdateBatchPredictionRequest
  ): IO[
    AwsError,
    zio.aws.machinelearning.model.UpdateBatchPredictionResponse.ReadOnly
  ]
  def describeTags(
      request: zio.aws.machinelearning.model.DescribeTagsRequest
  ): IO[AwsError, zio.aws.machinelearning.model.DescribeTagsResponse.ReadOnly]
  def createDataSourceFromS3(
      request: zio.aws.machinelearning.model.CreateDataSourceFromS3Request
  ): IO[
    AwsError,
    zio.aws.machinelearning.model.CreateDataSourceFromS3Response.ReadOnly
  ]
  def getDataSource(
      request: zio.aws.machinelearning.model.GetDataSourceRequest
  ): IO[AwsError, zio.aws.machinelearning.model.GetDataSourceResponse.ReadOnly]
  def describeEvaluations(
      request: zio.aws.machinelearning.model.DescribeEvaluationsRequest
  ): ZStream[Any, AwsError, zio.aws.machinelearning.model.Evaluation.ReadOnly]
  def describeEvaluationsPaginated(
      request: zio.aws.machinelearning.model.DescribeEvaluationsRequest
  ): IO[
    AwsError,
    zio.aws.machinelearning.model.DescribeEvaluationsResponse.ReadOnly
  ]
  def deleteRealtimeEndpoint(
      request: zio.aws.machinelearning.model.DeleteRealtimeEndpointRequest
  ): IO[
    AwsError,
    zio.aws.machinelearning.model.DeleteRealtimeEndpointResponse.ReadOnly
  ]
  def addTags(
      request: zio.aws.machinelearning.model.AddTagsRequest
  ): IO[AwsError, zio.aws.machinelearning.model.AddTagsResponse.ReadOnly]
  def deleteMLModel(
      request: zio.aws.machinelearning.model.DeleteMlModelRequest
  ): IO[AwsError, zio.aws.machinelearning.model.DeleteMlModelResponse.ReadOnly]
  def predict(
      request: zio.aws.machinelearning.model.PredictRequest
  ): IO[AwsError, zio.aws.machinelearning.model.PredictResponse.ReadOnly]
  def createRealtimeEndpoint(
      request: zio.aws.machinelearning.model.CreateRealtimeEndpointRequest
  ): IO[
    AwsError,
    zio.aws.machinelearning.model.CreateRealtimeEndpointResponse.ReadOnly
  ]
  def createMLModel(
      request: zio.aws.machinelearning.model.CreateMlModelRequest
  ): IO[AwsError, zio.aws.machinelearning.model.CreateMlModelResponse.ReadOnly]
  def createEvaluation(
      request: zio.aws.machinelearning.model.CreateEvaluationRequest
  ): IO[
    AwsError,
    zio.aws.machinelearning.model.CreateEvaluationResponse.ReadOnly
  ]
  def updateEvaluation(
      request: zio.aws.machinelearning.model.UpdateEvaluationRequest
  ): IO[
    AwsError,
    zio.aws.machinelearning.model.UpdateEvaluationResponse.ReadOnly
  ]
  def createDataSourceFromRedshift(
      request: zio.aws.machinelearning.model.CreateDataSourceFromRedshiftRequest
  ): IO[
    AwsError,
    zio.aws.machinelearning.model.CreateDataSourceFromRedshiftResponse.ReadOnly
  ]
  def getEvaluation(
      request: zio.aws.machinelearning.model.GetEvaluationRequest
  ): IO[AwsError, zio.aws.machinelearning.model.GetEvaluationResponse.ReadOnly]
  def getMLModel(
      request: zio.aws.machinelearning.model.GetMlModelRequest
  ): IO[AwsError, ReadOnly]
  def createBatchPrediction(
      request: zio.aws.machinelearning.model.CreateBatchPredictionRequest
  ): IO[
    AwsError,
    zio.aws.machinelearning.model.CreateBatchPredictionResponse.ReadOnly
  ]
  def updateDataSource(
      request: zio.aws.machinelearning.model.UpdateDataSourceRequest
  ): IO[
    AwsError,
    zio.aws.machinelearning.model.UpdateDataSourceResponse.ReadOnly
  ]
  def deleteDataSource(
      request: zio.aws.machinelearning.model.DeleteDataSourceRequest
  ): IO[
    AwsError,
    zio.aws.machinelearning.model.DeleteDataSourceResponse.ReadOnly
  ]
  def deleteBatchPrediction(
      request: zio.aws.machinelearning.model.DeleteBatchPredictionRequest
  ): IO[
    AwsError,
    zio.aws.machinelearning.model.DeleteBatchPredictionResponse.ReadOnly
  ]
  def describeMLModels(
      request: zio.aws.machinelearning.model.DescribeMlModelsRequest
  ): ZStream[Any, AwsError, zio.aws.machinelearning.model.MLModel.ReadOnly]
  def describeMLModelsPaginated(
      request: zio.aws.machinelearning.model.DescribeMlModelsRequest
  ): IO[
    AwsError,
    zio.aws.machinelearning.model.DescribeMlModelsResponse.ReadOnly
  ]
  def deleteEvaluation(
      request: zio.aws.machinelearning.model.DeleteEvaluationRequest
  ): IO[
    AwsError,
    zio.aws.machinelearning.model.DeleteEvaluationResponse.ReadOnly
  ]
  def createDataSourceFromRDS(
      request: zio.aws.machinelearning.model.CreateDataSourceFromRdsRequest
  ): IO[
    AwsError,
    zio.aws.machinelearning.model.CreateDataSourceFromRdsResponse.ReadOnly
  ]
  def describeBatchPredictions(
      request: zio.aws.machinelearning.model.DescribeBatchPredictionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.machinelearning.model.BatchPrediction.ReadOnly
  ]
  def describeBatchPredictionsPaginated(
      request: zio.aws.machinelearning.model.DescribeBatchPredictionsRequest
  ): IO[
    AwsError,
    zio.aws.machinelearning.model.DescribeBatchPredictionsResponse.ReadOnly
  ]
  def describeDataSources(
      request: zio.aws.machinelearning.model.DescribeDataSourcesRequest
  ): ZStream[Any, AwsError, zio.aws.machinelearning.model.DataSource.ReadOnly]
  def describeDataSourcesPaginated(
      request: zio.aws.machinelearning.model.DescribeDataSourcesRequest
  ): IO[
    AwsError,
    zio.aws.machinelearning.model.DescribeDataSourcesResponse.ReadOnly
  ]
  def deleteTags(
      request: zio.aws.machinelearning.model.DeleteTagsRequest
  ): IO[AwsError, zio.aws.machinelearning.model.DeleteTagsResponse.ReadOnly]
  def updateMLModel(
      request: zio.aws.machinelearning.model.UpdateMlModelRequest
  ): IO[AwsError, zio.aws.machinelearning.model.UpdateMlModelResponse.ReadOnly]
  def getBatchPrediction(
      request: zio.aws.machinelearning.model.GetBatchPredictionRequest
  ): IO[
    AwsError,
    zio.aws.machinelearning.model.GetBatchPredictionResponse.ReadOnly
  ]
}
object MachineLearning {
  val live: ZLayer[AwsConfig, java.lang.Throwable, MachineLearning] =
    customized(identity)
  def customized(
      customization: MachineLearningAsyncClientBuilder => MachineLearningAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, MachineLearning] = managed(
    customization
  ).toLayer
  def managed(
      customization: MachineLearningAsyncClientBuilder => MachineLearningAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, MachineLearning] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = MachineLearningAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[MachineLearningAsyncClient, MachineLearningAsyncClientBuilder](
        builder
      )
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        MachineLearningAsyncClient,
        MachineLearningAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new MachineLearningImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class MachineLearningImpl[R](
      override val api: MachineLearningAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends MachineLearning
      with AwsServiceBase[R] {
    override val serviceName: String = "MachineLearning"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): MachineLearningImpl[R1] = new MachineLearningImpl(api, newAspect, r)
    def updateBatchPrediction(
        request: zio.aws.machinelearning.model.UpdateBatchPredictionRequest
    ): IO[
      AwsError,
      zio.aws.machinelearning.model.UpdateBatchPredictionResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateBatchPredictionRequest,
      UpdateBatchPredictionResponse
    ]("updateBatchPrediction", api.updateBatchPrediction)(
      request.buildAwsValue()
    ).map(zio.aws.machinelearning.model.UpdateBatchPredictionResponse.wrap)
      .provideEnvironment(r)
    def describeTags(
        request: zio.aws.machinelearning.model.DescribeTagsRequest
    ): IO[
      AwsError,
      zio.aws.machinelearning.model.DescribeTagsResponse.ReadOnly
    ] = asyncRequestResponse[DescribeTagsRequest, DescribeTagsResponse](
      "describeTags",
      api.describeTags
    )(request.buildAwsValue())
      .map(zio.aws.machinelearning.model.DescribeTagsResponse.wrap)
      .provideEnvironment(r)
    def createDataSourceFromS3(
        request: zio.aws.machinelearning.model.CreateDataSourceFromS3Request
    ): IO[
      AwsError,
      zio.aws.machinelearning.model.CreateDataSourceFromS3Response.ReadOnly
    ] = asyncRequestResponse[
      CreateDataSourceFromS3Request,
      CreateDataSourceFromS3Response
    ]("createDataSourceFromS3", api.createDataSourceFromS3)(
      request.buildAwsValue()
    ).map(zio.aws.machinelearning.model.CreateDataSourceFromS3Response.wrap)
      .provideEnvironment(r)
    def getDataSource(
        request: zio.aws.machinelearning.model.GetDataSourceRequest
    ): IO[
      AwsError,
      zio.aws.machinelearning.model.GetDataSourceResponse.ReadOnly
    ] = asyncRequestResponse[GetDataSourceRequest, GetDataSourceResponse](
      "getDataSource",
      api.getDataSource
    )(request.buildAwsValue())
      .map(zio.aws.machinelearning.model.GetDataSourceResponse.wrap)
      .provideEnvironment(r)
    def describeEvaluations(
        request: zio.aws.machinelearning.model.DescribeEvaluationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.machinelearning.model.Evaluation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeEvaluationsRequest,
      DescribeEvaluationsResponse,
      Evaluation
    ](
      "describeEvaluations",
      api.describeEvaluations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.results().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.machinelearning.model.Evaluation.wrap(item))
      .provideEnvironment(r)
    def describeEvaluationsPaginated(
        request: zio.aws.machinelearning.model.DescribeEvaluationsRequest
    ): IO[
      AwsError,
      zio.aws.machinelearning.model.DescribeEvaluationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeEvaluationsRequest,
      DescribeEvaluationsResponse
    ]("describeEvaluations", api.describeEvaluations)(request.buildAwsValue())
      .map(zio.aws.machinelearning.model.DescribeEvaluationsResponse.wrap)
      .provideEnvironment(r)
    def deleteRealtimeEndpoint(
        request: zio.aws.machinelearning.model.DeleteRealtimeEndpointRequest
    ): IO[
      AwsError,
      zio.aws.machinelearning.model.DeleteRealtimeEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteRealtimeEndpointRequest,
      DeleteRealtimeEndpointResponse
    ]("deleteRealtimeEndpoint", api.deleteRealtimeEndpoint)(
      request.buildAwsValue()
    ).map(zio.aws.machinelearning.model.DeleteRealtimeEndpointResponse.wrap)
      .provideEnvironment(r)
    def addTags(
        request: zio.aws.machinelearning.model.AddTagsRequest
    ): IO[AwsError, zio.aws.machinelearning.model.AddTagsResponse.ReadOnly] =
      asyncRequestResponse[AddTagsRequest, AddTagsResponse](
        "addTags",
        api.addTags
      )(request.buildAwsValue())
        .map(zio.aws.machinelearning.model.AddTagsResponse.wrap)
        .provideEnvironment(r)
    def deleteMLModel(
        request: zio.aws.machinelearning.model.DeleteMlModelRequest
    ): IO[
      AwsError,
      zio.aws.machinelearning.model.DeleteMlModelResponse.ReadOnly
    ] = asyncRequestResponse[DeleteMlModelRequest, DeleteMlModelResponse](
      "deleteMLModel",
      api.deleteMLModel
    )(request.buildAwsValue())
      .map(zio.aws.machinelearning.model.DeleteMlModelResponse.wrap)
      .provideEnvironment(r)
    def predict(
        request: zio.aws.machinelearning.model.PredictRequest
    ): IO[AwsError, zio.aws.machinelearning.model.PredictResponse.ReadOnly] =
      asyncRequestResponse[PredictRequest, PredictResponse](
        "predict",
        api.predict
      )(request.buildAwsValue())
        .map(zio.aws.machinelearning.model.PredictResponse.wrap)
        .provideEnvironment(r)
    def createRealtimeEndpoint(
        request: zio.aws.machinelearning.model.CreateRealtimeEndpointRequest
    ): IO[
      AwsError,
      zio.aws.machinelearning.model.CreateRealtimeEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateRealtimeEndpointRequest,
      CreateRealtimeEndpointResponse
    ]("createRealtimeEndpoint", api.createRealtimeEndpoint)(
      request.buildAwsValue()
    ).map(zio.aws.machinelearning.model.CreateRealtimeEndpointResponse.wrap)
      .provideEnvironment(r)
    def createMLModel(
        request: zio.aws.machinelearning.model.CreateMlModelRequest
    ): IO[
      AwsError,
      zio.aws.machinelearning.model.CreateMlModelResponse.ReadOnly
    ] = asyncRequestResponse[CreateMlModelRequest, CreateMlModelResponse](
      "createMLModel",
      api.createMLModel
    )(request.buildAwsValue())
      .map(zio.aws.machinelearning.model.CreateMlModelResponse.wrap)
      .provideEnvironment(r)
    def createEvaluation(
        request: zio.aws.machinelearning.model.CreateEvaluationRequest
    ): IO[
      AwsError,
      zio.aws.machinelearning.model.CreateEvaluationResponse.ReadOnly
    ] = asyncRequestResponse[CreateEvaluationRequest, CreateEvaluationResponse](
      "createEvaluation",
      api.createEvaluation
    )(request.buildAwsValue())
      .map(zio.aws.machinelearning.model.CreateEvaluationResponse.wrap)
      .provideEnvironment(r)
    def updateEvaluation(
        request: zio.aws.machinelearning.model.UpdateEvaluationRequest
    ): IO[
      AwsError,
      zio.aws.machinelearning.model.UpdateEvaluationResponse.ReadOnly
    ] = asyncRequestResponse[UpdateEvaluationRequest, UpdateEvaluationResponse](
      "updateEvaluation",
      api.updateEvaluation
    )(request.buildAwsValue())
      .map(zio.aws.machinelearning.model.UpdateEvaluationResponse.wrap)
      .provideEnvironment(r)
    def createDataSourceFromRedshift(
        request: zio.aws.machinelearning.model.CreateDataSourceFromRedshiftRequest
    ): IO[
      AwsError,
      zio.aws.machinelearning.model.CreateDataSourceFromRedshiftResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateDataSourceFromRedshiftRequest,
      CreateDataSourceFromRedshiftResponse
    ]("createDataSourceFromRedshift", api.createDataSourceFromRedshift)(
      request.buildAwsValue()
    ).map(
      zio.aws.machinelearning.model.CreateDataSourceFromRedshiftResponse.wrap
    ).provideEnvironment(r)
    def getEvaluation(
        request: zio.aws.machinelearning.model.GetEvaluationRequest
    ): IO[
      AwsError,
      zio.aws.machinelearning.model.GetEvaluationResponse.ReadOnly
    ] = asyncRequestResponse[GetEvaluationRequest, GetEvaluationResponse](
      "getEvaluation",
      api.getEvaluation
    )(request.buildAwsValue())
      .map(zio.aws.machinelearning.model.GetEvaluationResponse.wrap)
      .provideEnvironment(r)
    def getMLModel(
        request: zio.aws.machinelearning.model.GetMlModelRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[GetMlModelRequest, GetMlModelResponse](
        "getMLModel",
        api.getMLModel
      )(request.buildAwsValue())
        .map(zio.aws.machinelearning.model.GetMlModelResponse.wrap)
        .provideEnvironment(r)
    def createBatchPrediction(
        request: zio.aws.machinelearning.model.CreateBatchPredictionRequest
    ): IO[
      AwsError,
      zio.aws.machinelearning.model.CreateBatchPredictionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateBatchPredictionRequest,
      CreateBatchPredictionResponse
    ]("createBatchPrediction", api.createBatchPrediction)(
      request.buildAwsValue()
    ).map(zio.aws.machinelearning.model.CreateBatchPredictionResponse.wrap)
      .provideEnvironment(r)
    def updateDataSource(
        request: zio.aws.machinelearning.model.UpdateDataSourceRequest
    ): IO[
      AwsError,
      zio.aws.machinelearning.model.UpdateDataSourceResponse.ReadOnly
    ] = asyncRequestResponse[UpdateDataSourceRequest, UpdateDataSourceResponse](
      "updateDataSource",
      api.updateDataSource
    )(request.buildAwsValue())
      .map(zio.aws.machinelearning.model.UpdateDataSourceResponse.wrap)
      .provideEnvironment(r)
    def deleteDataSource(
        request: zio.aws.machinelearning.model.DeleteDataSourceRequest
    ): IO[
      AwsError,
      zio.aws.machinelearning.model.DeleteDataSourceResponse.ReadOnly
    ] = asyncRequestResponse[DeleteDataSourceRequest, DeleteDataSourceResponse](
      "deleteDataSource",
      api.deleteDataSource
    )(request.buildAwsValue())
      .map(zio.aws.machinelearning.model.DeleteDataSourceResponse.wrap)
      .provideEnvironment(r)
    def deleteBatchPrediction(
        request: zio.aws.machinelearning.model.DeleteBatchPredictionRequest
    ): IO[
      AwsError,
      zio.aws.machinelearning.model.DeleteBatchPredictionResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteBatchPredictionRequest,
      DeleteBatchPredictionResponse
    ]("deleteBatchPrediction", api.deleteBatchPrediction)(
      request.buildAwsValue()
    ).map(zio.aws.machinelearning.model.DeleteBatchPredictionResponse.wrap)
      .provideEnvironment(r)
    def describeMLModels(
        request: zio.aws.machinelearning.model.DescribeMlModelsRequest
    ): ZStream[Any, AwsError, zio.aws.machinelearning.model.MLModel.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeMlModelsRequest,
        DescribeMlModelsResponse,
        MLModel
      ](
        "describeMLModels",
        api.describeMLModels,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.results().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.machinelearning.model.MLModel.wrap(item))
        .provideEnvironment(r)
    def describeMLModelsPaginated(
        request: zio.aws.machinelearning.model.DescribeMlModelsRequest
    ): IO[
      AwsError,
      zio.aws.machinelearning.model.DescribeMlModelsResponse.ReadOnly
    ] = asyncRequestResponse[DescribeMlModelsRequest, DescribeMlModelsResponse](
      "describeMLModels",
      api.describeMLModels
    )(request.buildAwsValue())
      .map(zio.aws.machinelearning.model.DescribeMlModelsResponse.wrap)
      .provideEnvironment(r)
    def deleteEvaluation(
        request: zio.aws.machinelearning.model.DeleteEvaluationRequest
    ): IO[
      AwsError,
      zio.aws.machinelearning.model.DeleteEvaluationResponse.ReadOnly
    ] = asyncRequestResponse[DeleteEvaluationRequest, DeleteEvaluationResponse](
      "deleteEvaluation",
      api.deleteEvaluation
    )(request.buildAwsValue())
      .map(zio.aws.machinelearning.model.DeleteEvaluationResponse.wrap)
      .provideEnvironment(r)
    def createDataSourceFromRDS(
        request: zio.aws.machinelearning.model.CreateDataSourceFromRdsRequest
    ): IO[
      AwsError,
      zio.aws.machinelearning.model.CreateDataSourceFromRdsResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateDataSourceFromRdsRequest,
      CreateDataSourceFromRdsResponse
    ]("createDataSourceFromRDS", api.createDataSourceFromRDS)(
      request.buildAwsValue()
    ).map(zio.aws.machinelearning.model.CreateDataSourceFromRdsResponse.wrap)
      .provideEnvironment(r)
    def describeBatchPredictions(
        request: zio.aws.machinelearning.model.DescribeBatchPredictionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.machinelearning.model.BatchPrediction.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeBatchPredictionsRequest,
      DescribeBatchPredictionsResponse,
      BatchPrediction
    ](
      "describeBatchPredictions",
      api.describeBatchPredictions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.results().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.machinelearning.model.BatchPrediction.wrap(item))
      .provideEnvironment(r)
    def describeBatchPredictionsPaginated(
        request: zio.aws.machinelearning.model.DescribeBatchPredictionsRequest
    ): IO[
      AwsError,
      zio.aws.machinelearning.model.DescribeBatchPredictionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeBatchPredictionsRequest,
      DescribeBatchPredictionsResponse
    ]("describeBatchPredictions", api.describeBatchPredictions)(
      request.buildAwsValue()
    ).map(zio.aws.machinelearning.model.DescribeBatchPredictionsResponse.wrap)
      .provideEnvironment(r)
    def describeDataSources(
        request: zio.aws.machinelearning.model.DescribeDataSourcesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.machinelearning.model.DataSource.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeDataSourcesRequest,
      DescribeDataSourcesResponse,
      DataSource
    ](
      "describeDataSources",
      api.describeDataSources,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.results().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.machinelearning.model.DataSource.wrap(item))
      .provideEnvironment(r)
    def describeDataSourcesPaginated(
        request: zio.aws.machinelearning.model.DescribeDataSourcesRequest
    ): IO[
      AwsError,
      zio.aws.machinelearning.model.DescribeDataSourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDataSourcesRequest,
      DescribeDataSourcesResponse
    ]("describeDataSources", api.describeDataSources)(request.buildAwsValue())
      .map(zio.aws.machinelearning.model.DescribeDataSourcesResponse.wrap)
      .provideEnvironment(r)
    def deleteTags(
        request: zio.aws.machinelearning.model.DeleteTagsRequest
    ): IO[AwsError, zio.aws.machinelearning.model.DeleteTagsResponse.ReadOnly] =
      asyncRequestResponse[DeleteTagsRequest, DeleteTagsResponse](
        "deleteTags",
        api.deleteTags
      )(request.buildAwsValue())
        .map(zio.aws.machinelearning.model.DeleteTagsResponse.wrap)
        .provideEnvironment(r)
    def updateMLModel(
        request: zio.aws.machinelearning.model.UpdateMlModelRequest
    ): IO[
      AwsError,
      zio.aws.machinelearning.model.UpdateMlModelResponse.ReadOnly
    ] = asyncRequestResponse[UpdateMlModelRequest, UpdateMlModelResponse](
      "updateMLModel",
      api.updateMLModel
    )(request.buildAwsValue())
      .map(zio.aws.machinelearning.model.UpdateMlModelResponse.wrap)
      .provideEnvironment(r)
    def getBatchPrediction(
        request: zio.aws.machinelearning.model.GetBatchPredictionRequest
    ): IO[
      AwsError,
      zio.aws.machinelearning.model.GetBatchPredictionResponse.ReadOnly
    ] = asyncRequestResponse[
      GetBatchPredictionRequest,
      GetBatchPredictionResponse
    ]("getBatchPrediction", api.getBatchPrediction)(request.buildAwsValue())
      .map(zio.aws.machinelearning.model.GetBatchPredictionResponse.wrap)
      .provideEnvironment(r)
  }
  def updateBatchPrediction(
      request: zio.aws.machinelearning.model.UpdateBatchPredictionRequest
  ): ZIO[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.UpdateBatchPredictionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateBatchPrediction(request))
  def describeTags(
      request: zio.aws.machinelearning.model.DescribeTagsRequest
  ): ZIO[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.DescribeTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTags(request))
  def createDataSourceFromS3(
      request: zio.aws.machinelearning.model.CreateDataSourceFromS3Request
  ): ZIO[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.CreateDataSourceFromS3Response.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataSourceFromS3(request))
  def getDataSource(
      request: zio.aws.machinelearning.model.GetDataSourceRequest
  ): ZIO[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.GetDataSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDataSource(request))
  def describeEvaluations(
      request: zio.aws.machinelearning.model.DescribeEvaluationsRequest
  ): ZStream[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.Evaluation.ReadOnly
  ] = ZStream.serviceWithStream(_.describeEvaluations(request))
  def describeEvaluationsPaginated(
      request: zio.aws.machinelearning.model.DescribeEvaluationsRequest
  ): ZIO[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.DescribeEvaluationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEvaluationsPaginated(request))
  def deleteRealtimeEndpoint(
      request: zio.aws.machinelearning.model.DeleteRealtimeEndpointRequest
  ): ZIO[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.DeleteRealtimeEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteRealtimeEndpoint(request))
  def addTags(request: zio.aws.machinelearning.model.AddTagsRequest): ZIO[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.AddTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addTags(request))
  def deleteMLModel(
      request: zio.aws.machinelearning.model.DeleteMlModelRequest
  ): ZIO[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.DeleteMlModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteMLModel(request))
  def predict(request: zio.aws.machinelearning.model.PredictRequest): ZIO[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.PredictResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.predict(request))
  def createRealtimeEndpoint(
      request: zio.aws.machinelearning.model.CreateRealtimeEndpointRequest
  ): ZIO[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.CreateRealtimeEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRealtimeEndpoint(request))
  def createMLModel(
      request: zio.aws.machinelearning.model.CreateMlModelRequest
  ): ZIO[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.CreateMlModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMLModel(request))
  def createEvaluation(
      request: zio.aws.machinelearning.model.CreateEvaluationRequest
  ): ZIO[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.CreateEvaluationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEvaluation(request))
  def updateEvaluation(
      request: zio.aws.machinelearning.model.UpdateEvaluationRequest
  ): ZIO[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.UpdateEvaluationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEvaluation(request))
  def createDataSourceFromRedshift(
      request: zio.aws.machinelearning.model.CreateDataSourceFromRedshiftRequest
  ): ZIO[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.CreateDataSourceFromRedshiftResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataSourceFromRedshift(request))
  def getEvaluation(
      request: zio.aws.machinelearning.model.GetEvaluationRequest
  ): ZIO[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.GetEvaluationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEvaluation(request))
  def getMLModel(
      request: zio.aws.machinelearning.model.GetMlModelRequest
  ): ZIO[zio.aws.machinelearning.MachineLearning, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getMLModel(request))
  def createBatchPrediction(
      request: zio.aws.machinelearning.model.CreateBatchPredictionRequest
  ): ZIO[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.CreateBatchPredictionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBatchPrediction(request))
  def updateDataSource(
      request: zio.aws.machinelearning.model.UpdateDataSourceRequest
  ): ZIO[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.UpdateDataSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDataSource(request))
  def deleteDataSource(
      request: zio.aws.machinelearning.model.DeleteDataSourceRequest
  ): ZIO[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.DeleteDataSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDataSource(request))
  def deleteBatchPrediction(
      request: zio.aws.machinelearning.model.DeleteBatchPredictionRequest
  ): ZIO[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.DeleteBatchPredictionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteBatchPrediction(request))
  def describeMLModels(
      request: zio.aws.machinelearning.model.DescribeMlModelsRequest
  ): ZStream[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.MLModel.ReadOnly
  ] = ZStream.serviceWithStream(_.describeMLModels(request))
  def describeMLModelsPaginated(
      request: zio.aws.machinelearning.model.DescribeMlModelsRequest
  ): ZIO[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.DescribeMlModelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeMLModelsPaginated(request))
  def deleteEvaluation(
      request: zio.aws.machinelearning.model.DeleteEvaluationRequest
  ): ZIO[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.DeleteEvaluationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEvaluation(request))
  def createDataSourceFromRDS(
      request: zio.aws.machinelearning.model.CreateDataSourceFromRdsRequest
  ): ZIO[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.CreateDataSourceFromRdsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataSourceFromRDS(request))
  def describeBatchPredictions(
      request: zio.aws.machinelearning.model.DescribeBatchPredictionsRequest
  ): ZStream[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.BatchPrediction.ReadOnly
  ] = ZStream.serviceWithStream(_.describeBatchPredictions(request))
  def describeBatchPredictionsPaginated(
      request: zio.aws.machinelearning.model.DescribeBatchPredictionsRequest
  ): ZIO[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.DescribeBatchPredictionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeBatchPredictionsPaginated(request))
  def describeDataSources(
      request: zio.aws.machinelearning.model.DescribeDataSourcesRequest
  ): ZStream[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.DataSource.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDataSources(request))
  def describeDataSourcesPaginated(
      request: zio.aws.machinelearning.model.DescribeDataSourcesRequest
  ): ZIO[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.DescribeDataSourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDataSourcesPaginated(request))
  def deleteTags(request: zio.aws.machinelearning.model.DeleteTagsRequest): ZIO[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.DeleteTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTags(request))
  def updateMLModel(
      request: zio.aws.machinelearning.model.UpdateMlModelRequest
  ): ZIO[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.UpdateMlModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateMLModel(request))
  def getBatchPrediction(
      request: zio.aws.machinelearning.model.GetBatchPredictionRequest
  ): ZIO[
    zio.aws.machinelearning.MachineLearning,
    AwsError,
    zio.aws.machinelearning.model.GetBatchPredictionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBatchPrediction(request))
}
