/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.mcdiscordreserializer.renderer;

import dev.vankka.mcdiscordreserializer.minecraft.MinecraftSerializerOptions;
import dev.vankka.mcdiscordreserializer.renderer.MinecraftNodeRenderer;
import dev.vankka.mcdiscordreserializer.rules.DiscordMarkdownRules;
import dev.vankka.simpleast.core.TextStyle;
import dev.vankka.simpleast.core.node.Node;
import dev.vankka.simpleast.core.node.StyleNode;
import dev.vankka.simpleast.core.node.TextNode;
import java.util.ArrayList;
import java.util.function.Function;
import lombok.NonNull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface MinecraftRenderer
extends MinecraftNodeRenderer {
    @Override
    default public Component render(Component component, Node<Object> node, MinecraftSerializerOptions<Component> serializerOptions, Function<Node<Object>, Component> renderWithChildren) {
        if (node instanceof TextNode) {
            component = ((TextComponent)component).content(((TextNode)node).getContent());
        } else if (node instanceof StyleNode) {
            ArrayList styles = new ArrayList(((StyleNode)node).getStyles());
            for (TextStyle style : styles) {
                switch (style.getType()) {
                    case STRIKETHROUGH: {
                        component = this.strikethrough(component);
                        break;
                    }
                    case UNDERLINE: {
                        component = this.underline(component);
                        break;
                    }
                    case ITALICS: {
                        component = this.italics(component);
                        break;
                    }
                    case BOLD: {
                        component = this.bold(component);
                        break;
                    }
                    case CODE_STRING: {
                        component = this.codeString(component);
                        ((StyleNode)node).getStyles().remove(style);
                        break;
                    }
                    case CODE_BLOCK: {
                        component = this.codeBlock(component);
                        ((StyleNode)node).getStyles().remove(style);
                        break;
                    }
                    case QUOTE: {
                        TextComponent content = Component.empty();
                        for (Node objectNode : serializerOptions.getParser().parse((CharSequence)style.getExtra().get("content"), (Object)new DiscordMarkdownRules.QuoteState(true), serializerOptions.getRules(), serializerOptions.isDebuggingEnabled())) {
                            content = (TextComponent)content.append(renderWithChildren.apply((Node<Object>)objectNode));
                        }
                        component = this.appendQuote(component, (Component)content);
                        break;
                    }
                    case SPOILER: {
                        TextComponent content = Component.empty();
                        for (Node objectNode : serializerOptions.getParser().parse((CharSequence)style.getExtra().get("content"), null, serializerOptions.getRules(), serializerOptions.isDebuggingEnabled())) {
                            content = (TextComponent)content.append(renderWithChildren.apply((Node<Object>)objectNode));
                        }
                        component = this.appendSpoiler(component, (Component)content);
                        break;
                    }
                    case MENTION_EMOJI: {
                        component = this.appendEmoteMention(component, (String)style.getExtra().get("name"), (String)style.getExtra().get("id"));
                        break;
                    }
                    case MENTION_CHANNEL: {
                        component = this.appendChannelMention(component, (String)style.getExtra().get("id"));
                        break;
                    }
                    case MENTION_USER: {
                        component = this.appendUserMention(component, (String)style.getExtra().get("id"));
                        break;
                    }
                    case MENTION_ROLE: {
                        component = this.appendRoleMention(component, (String)style.getExtra().get("id"));
                        break;
                    }
                }
            }
        }
        return component;
    }

    public @Nullable Component strikethrough(@NonNull Component var1);

    public @Nullable Component underline(@NonNull Component var1);

    public @Nullable Component italics(@NonNull Component var1);

    public @Nullable Component bold(@NonNull Component var1);

    public @Nullable Component codeString(@NonNull Component var1);

    public @Nullable Component codeBlock(@NonNull Component var1);

    public @Nullable Component appendSpoiler(@NonNull Component var1, @NonNull Component var2);

    public @Nullable Component appendQuote(@NonNull Component var1, @NonNull Component var2);

    public @Nullable Component appendEmoteMention(@NonNull Component var1, @NonNull String var2, @NonNull String var3);

    public @Nullable Component appendChannelMention(@NonNull Component var1, @NonNull String var2);

    public @Nullable Component appendUserMention(@NonNull Component var1, @NonNull String var2);

    public @Nullable Component appendRoleMention(@NonNull Component var1, @NonNull String var2);
}

