/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.command.PullImageResultCallback;
import com.github.dockerjava.api.model.Image;
import dev.snowdrop.buildpack.BuildpackException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtils {
    private static final Logger log = LoggerFactory.getLogger(ImageUtils.class);

    public static void pullImages(DockerClient dc, int timeoutSeconds, String ... imageNames) {
        HashSet<String> imageNameSet = new HashSet<String>(Arrays.asList(imageNames));
        List li = (List)dc.listImagesCmd().exec();
        for (Image i : li) {
            if (i.getRepoTags() == null) continue;
            for (String it : i.getRepoTags()) {
                if (!imageNameSet.contains(it)) continue;
                imageNameSet.remove(it);
            }
        }
        if (imageNameSet.isEmpty()) {
            log.debug("Nothing to pull, all of " + Arrays.asList(imageNames) + " are known");
            return;
        }
        ArrayList<PullImageResultCallback> pircs = new ArrayList<PullImageResultCallback>();
        for (String stillNeeded : imageNameSet) {
            log.debug("pulling '" + stillNeeded + "'");
            PullImageResultCallback pirc = new PullImageResultCallback();
            dc.pullImageCmd(stillNeeded).exec((ResultCallback)pirc);
            pircs.add(pirc);
        }
        for (PullImageResultCallback pirc : pircs) {
            try {
                pirc.awaitCompletion((long)timeoutSeconds, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw BuildpackException.launderThrowable(e);
            }
        }
    }

    public static ImageInfo inspectImage(DockerClient dc, String imageName) {
        InspectImageResponse iir = dc.inspectImageCmd(imageName).exec();
        ImageInfo ii = new ImageInfo();
        ii.id = iir.getId();
        ii.labels = iir.getConfig().getLabels();
        ii.env = iir.getConfig().getEnv();
        return ii;
    }

    public static class ImageInfo {
        public String id;
        public Map<String, String> labels;
        public String[] env;
    }
}

