/*
 * Decompiled with CFR 0.152.
 */
package dev.paseto.jpaseto.impl.crypto;

import dev.paseto.jpaseto.PasetoIOException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class PreAuthEncoder {
    private PreAuthEncoder() {
    }

    public static byte[] encode(byte[] ... inputs) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            stream.write(PreAuthEncoder.toLongLe(inputs.length));
            for (byte[] input : inputs) {
                stream.write(PreAuthEncoder.toLongLe(input.length));
                stream.write(input);
            }
            return stream.toByteArray();
        }
        catch (IOException e) {
            throw new PasetoIOException("Failed to encode preAuth", (Throwable)e);
        }
    }

    private static byte[] toLongLe(long input) {
        long unsignedLong = input & Long.MAX_VALUE;
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putLong(unsignedLong);
        return buffer.array();
    }
}

